# -*- coding: utf-8 -*-

import logging
import json
import time
import requests

from sandbox import sdk2


class MarketShopsAutotestMetrics(sdk2.Task):
    """ Get autotest statistics and send it to statface """

    def on_execute(self):
        secret_name_testpalm = "robot-market-autotst-oauth-testpalm"
        secret_name_statface = "robot-market-autotst-oauth-statface"
        secret_name_st = "robot-market-autotst-oauth-st"

        url_actual_autotest = "https://testpalm.yandex-team.ru/api/testcases/marketmbi?isAutotest=true&status=actual&status=automated"
        url_regress = "https://testpalm.yandex-team.ru/api/testcases/marketmbi/groups/testsuite/5c7810736acd3de654c51e60"
        url_all_manual = "https://testpalm.yandex-team.ru/api/testcases/marketmbi?isAutotest=false&status=actual"
        url_autotests_in_projects = "https://st-api.yandex-team.ru/v2/issues/_count?query=Queue: MARKETPARTNER Type:Test Status:!Closed"
        url_autotests_manual_regression = "https://st-api.yandex-team.ru/v2/issues/_count?query=Queue: MARKETPARTNER Type:Test Status:Open Tags:manual_regression"
        url_autotests_fix = "https://st-api.yandex-team.ru/v2/issues/_count?query=Queue: MARKETPARTNER Tags: js_broken Status:!Closed"
        url_autotests_all_open = "https://st-api.yandex-team.ru/v2/issues/_count?query=Queue: MARKETPARTNER Type: Test Status: Open"
        url_stat = "https://upload.stat.yandex-team.ru/_api/report/data"

        testpalm_token = sdk2.Vault.data(secret_name_testpalm)
        stat_token = sdk2.Vault.data(secret_name_statface)
        st_token = sdk2.Vault.data(secret_name_st)

        s = requests.Session()
        s.headers.update({'Authorization': 'OAuth {}'.format(testpalm_token)})

        st_requests = requests.session()
        st_requests.headers.update({'Authorization': 'OAuth {}'.format(st_token)})

        my_list_to_stat = []
        fieldnames = "fielddate,automated,manual_regression,all_manual,automated_percentage,st_all_open,st_for_fix,st_manual_regression,st_in_projects".split(",")
        vare = []

        testpalm_actual_autotest_bin = s.get(
            url_actual_autotest,
        )
        testpalm_regress_bin = s.get(
            url_regress,
        )
        testpalm_all_manual_bin = s.get(
            url_all_manual,
        )

        parsed_testpalm_actual_autotest = json.loads(testpalm_actual_autotest_bin.text)
        parsed_testpalm_regress = json.loads(testpalm_regress_bin.text)
        parsed_testpalm_all_manual = json.loads(testpalm_all_manual_bin.text)

        percentage = 100 * len(parsed_testpalm_actual_autotest) / (len(parsed_testpalm_actual_autotest) + len(parsed_testpalm_all_manual))

        # fielddate
        vare.append(str(time.strftime('%Y-%m-%d %H:%M:%S')))
        # automated
        vare.append(str(len(parsed_testpalm_actual_autotest)))
        # manual_regression_from_testpalm
        issues_in_manual_regression = 0
        for values in parsed_testpalm_regress["groups"]:
            issues_in_manual_regression += values["count"]
        vare.append(str(issues_in_manual_regression))
        # all_manual
        vare.append(str(len(parsed_testpalm_all_manual)))
        # automated_percentage
        vare.append(str(percentage))

        st_in_projects = st_requests.get(
            url_autotests_in_projects
        )
        st_manual_regression = st_requests.get(
            url_autotests_manual_regression
        )
        st_for_fix = st_requests.get(
            url_autotests_fix
        )
        st_all_open = st_requests.get(
            url_autotests_all_open
        )

        # st_all_open
        vare.append(str(st_all_open.text))
        # st_for_fix
        vare.append(str(st_for_fix.text))
        # st_manual_regression
        vare.append(str(st_manual_regression.text))
        # st_in_projects
        vare.append(str(st_in_projects.text))

        # concatinate fieldnames and vare and convert it to json
        my_list_to_stat.append(dict(zip(fieldnames, vare)))
        name = '/Market_Partner/testing/autotests/'
        scale = 's'
        arr_D = {"values": list(reversed(my_list_to_stat))}
        strr_D = json.dumps(arr_D)
        r = requests.post(
            url_stat,
            headers={'Authorization': 'OAuth {}'.format(stat_token)},
            data={
                'name': name,
                'scale': scale,
                'data': strr_D,
            },
            verify=False,
        )
        logging.info(r)

