# -*- coding: utf-8 -*-
import logging
import json
import time
import requests

from sandbox import sdk2


class MarketShopsReleaseMetrics(sdk2.Task):
    """ Get MARKETPARTNER release statistics and send it to statface """

    def on_execute(self):
        secret_name_testpalm = "robot-market-autotst-oauth-testpalm"
        secret_name_statface = "robot-market-autotst-oauth-statface"
        secret_name_st = "robot-market-autotst-oauth-st"

        testpalm_token = sdk2.Vault.data(secret_name_testpalm)
        stat_token = sdk2.Vault.data(secret_name_statface)
        st_token = sdk2.Vault.data(secret_name_st)

        url_testpalm = "https://testpalm.yandex-team.ru/api/testrun/marketmbi/preview?status=FINISHED"
        url_st_versions = "https://st-api.yandex-team.ru/v2/queues/MARKETPARTNER/versions"
        url_st_issues_in_versions = "https://st-api.yandex-team.ru/v2/issues/?filter=queue:MARKETPARTNER&filter=fixVersions:"

        def get_json_data(session, url):
            return json.loads(session.get(url).text)

        def count_autotest_stat(testpalm_values):
            result = []
            result.append(str(time.strftime(
                '%Y-%m-%d %H:%M:%S',
                time.localtime(testpalm_values["createdTime"] / 1000))))
            result.append(str(testpalm_values["executionTime"] / 1000 / 60))
            result.append(str(testpalm_values["resolution"]["counter"]["passed"]))
            result.append(str(testpalm_values["resolution"]["counter"]["broken"]))
            result.append(str(testpalm_values["resolution"]["counter"]["failed"]))
            result.append(str(testpalm_values["resolution"]["counter"]["skipped"]))
            result.append(
                "https://testpalm.yandex-team.ru/marketmbi/testrun/" +
                str(testpalm_values["id"])
            )
            return result

        def count_autotest_regression_releases(release_dict, testpalm_values, environment):
            if not release_dict['autotests_' + environment + '_time']:
                release_dict['autotests_' + environment + '_time'] = (testpalm_values["executionTime"] / 1000 / 60)
                release_dict['autotests_' + environment + '_run_count'] = 1
                release_dict['autotests_' + environment + '_passed'] = testpalm_values["resolution"]["counter"]["passed"]
                release_dict['autotests_' + environment + '_broken'] = testpalm_values["resolution"]["counter"]["broken"]
                release_dict['autotests_' + environment + '_failed'] = testpalm_values["resolution"]["counter"]["failed"]
            else:
                release_dict['autotests_' + environment + '_time'] += (testpalm_values["executionTime"] / 1000 / 60)
                release_dict['autotests_' + environment + '_run_count'] += 1
                release_dict['autotests_' + environment + '_passed'] += testpalm_values["resolution"]["counter"]["passed"]
                release_dict['autotests_' + environment + '_broken'] += testpalm_values["resolution"]["counter"]["broken"]
                release_dict['autotests_' + environment + '_failed'] += testpalm_values["resolution"]["counter"]["failed"]

        def count_manual_regression_releases(release_dict, testpalm_values):
            if not release_dict['manual_regression_time']:
                release_dict['manual_regression_time'] = count_manual_regression_time(testpalm_values)
                release_dict['manual_regression_run_count'] = 1
                release_dict['manual_regression_passed'] = testpalm_values["resolution"]["counter"]["passed"]
                release_dict['manual_regression_all'] = testpalm_values["resolution"]["counter"]["total"]
            else:
                release_dict['manual_regression_time'] += count_manual_regression_time(testpalm_values)
                release_dict['manual_regression_run_count'] += 1
                release_dict['manual_regression_passed'] += testpalm_values["resolution"]["counter"]["passed"]
                release_dict['manual_regression_all'] += testpalm_values["resolution"]["counter"]["total"]

        def count_manual_regression_time(testpalm_values):
            executionTime = testpalm_values["executionTime"] / 1000 / 60
            startTime = time.localtime(testpalm_values["createdTime"] / 1000)
            finishedTime = time.localtime(testpalm_values["finishedTime"]/1000)
            # Этот треш удалю, как только будет сделан https://st.yandex-team.ru/TESTPALM-1105
            if (str(time.strftime('%w', startTime)) == "5"):
                if (str(time.strftime('%w', finishedTime)) == "1"):
                    if (executionTime > 60 * (24 + 24 + 15)):
                        executionTime = executionTime - 60 * (24 + 24 + 15)
                    elif (executionTime > 60 * (24 + 24)):
                        executionTime = executionTime - 60 * (24 + 24)
                elif (str(time.strftime('%w', finishedTime)) == "2"):
                    if (executionTime > 60 * (24 + 24 + 24 + 15)):
                        executionTime = executionTime - 60 * (24 + 24 + 24 + 15)
                    elif (executionTime > 60 * (24 + 24 + 24)):
                        executionTime = executionTime - 60 * (24 + 24 + 24)
            elif (str(time.strftime('%w', startTime)) == "4"):
                if (str(time.strftime('%w', finishedTime)) == "0"):
                    if (executionTime > 60 * (24 + 24 + 15)):
                        executionTime = executionTime - 60 * (24 + 24 + 15)
                    elif (executionTime > 60 * (24 + 24)):
                        executionTime = executionTime - 60 * (24 + 24)
                if (str(time.strftime('%w', finishedTime)) == "1"):
                    if (executionTime > 60 * (24 + 24 + 24 + 15)):
                        executionTime = executionTime - 60 * (24 + 24 + 24 + 15)
            elif (str(time.strftime('%d', startTime)) != str(time.strftime('%d', finishedTime))):  # перескок дат – может некорректно считаться время выполнения
                if (executionTime > 60 * 15):  # если выполнялось больше 15 часов – вычитаем это время выполнения
                    executionTime = executionTime - 60 * 15  # 15 часов сна и отдыха вне работы из-за перескока дат
            return executionTime

        fieldnames_autotest = "fielddate,executiontime,passed,broken,failed,skipped,run".split(",")

        release_list = []
        testing_list_to_stat = []
        prestable_list_to_stat = []

        testpalm_session = requests.Session()
        testpalm_session.headers.update({'Authorization': 'OAuth {}'.format(testpalm_token)})
        parsed_testpalm = get_json_data(testpalm_session, url_testpalm)

        st_session = requests.Session()
        st_session.headers.update({'Authorization': 'OAuth {}'.format(st_token)})
        parsed_fix_version = get_json_data(st_session, url_st_versions)

        for values in parsed_fix_version[0:]:
            parsed_release = get_json_data(st_session, url_st_issues_in_versions + str(values["id"]))
            for current_release_value in parsed_release[0:]:
                release_dict = {
                    'hotfix': 0,
                    'manual_regression_time': '',
                    'manual_regression_run_count': '',
                    'manual_regression_passed': '',
                    'manual_regression_all': '',
                    'autotests_testing_time': '',
                    'autotests_testing_run_count': '',
                    'autotests_testing_passed': '',
                    'autotests_testing_broken': '',
                    'autotests_testing_failed': '',
                    'autotests_prestable_time': '',
                    'autotests_prestable_run_count': '',
                    'autotests_prestable_passed': '',
                    'autotests_prestable_broken': '',
                    'autotests_prestable_failed': ''
                }
                autotests_testing_vare = []
                autotests_prestable_vare = []
                if current_release_value["type"]["key"] == "release":
                    if current_release_value['status']['key'] == "closed":
                        if current_release_value['resolvedAt'][0:4] > '2018':
                            release_dict['fielddate'] = str(current_release_value['resolvedAt'][0:19])
                            release_dict['name'] = current_release_value['summary']
                            release_dict['ticket_count'] = len(parsed_release) - 1
                            release_dict['release_url'] = 'https://st.yandex-team.ru/' + current_release_value['key']
                            if current_release_value["summary"][0:7].encode('utf-8') == "Хотфикс":
                                release_dict['hotfix'] = 1
                            release_dict['release_count'] = 1
                            for testpalm_values in parsed_testpalm[0:]:
                                if ("parentIssue" in testpalm_values) and ("id" in testpalm_values["parentIssue"]):
                                    if testpalm_values["parentIssue"]["id"] == current_release_value["key"]:
                                        if (testpalm_values["executionTime"] / 1000 / 60) > 0:
                                            if testpalm_values["createdBy"] != "robot-metatron":
                                                if "external" in testpalm_values["launcherInfo"]:
                                                    if not testpalm_values["launcherInfo"]["external"]:
                                                        count_manual_regression_releases(release_dict, testpalm_values)
                                            elif testpalm_values["createdBy"] == "robot-metatron":
                                                if testpalm_values["properties"][0]["value"] == 'testing':
                                                    count_autotest_regression_releases(release_dict, testpalm_values, 'testing')
                                                    autotests_testing_vare = count_autotest_stat(testpalm_values)
                                                elif testpalm_values["properties"][0]["value"] == "prestable":
                                                    count_autotest_regression_releases(release_dict, testpalm_values, 'prestable')
                                                    autotests_prestable_vare = count_autotest_stat(testpalm_values)
                            release_list.append(release_dict)
                            if(len(autotests_testing_vare)):
                                testing_list_to_stat.append(dict(zip(fieldnames_autotest, autotests_testing_vare)))
                            if(len(autotests_prestable_vare)):
                                prestable_list_to_stat.append(dict(zip(fieldnames_autotest, autotests_prestable_vare)))


        report_names = {
            '/Market_Partner/testing/releases': release_list,
            '/Market_Partner/testing/autotest_time_prestable': prestable_list_to_stat,
            '/Market_Partner/testing/autotest_time_testing': testing_list_to_stat
        }
        scale = 's'
        for name in report_names:
            arr_D = {"values": list(reversed(report_names[name]))}
            strr_D = json.dumps(arr_D)
            r = requests.post(
                'https://upload.stat.yandex-team.ru/_api/report/data',
                headers={'Authorization': 'OAuth {}'.format(stat_token)},
                data={
                    'name': name,
                    'scale': scale,
                    'data': strr_D,
                },
                verify=False,
            )
            logging.info(name)
            logging.info(r)

