# coding=utf-8

import json
import hashlib

from enum import Enum

import requests
from sandbox import sdk2
from sandbox.common import types

import sys
reload(sys)
sys.setdefaultencoding('utf8')


pages_ids_path = 'arcadia:/arc/trunk/arcadia/sandbox/projects/market/recom/cms/Monitoring/pages_ids.tsv'
pages_pairs_ids_path = 'arcadia:/arc/trunk/arcadia/sandbox/projects/market/recom/cms/Monitoring/pairs_ids.tsv'

latest_revisions_api = 'http://mbo-cms-api.vs.market.yandex.net/v1/documents/{0}/revisions?limit=1&skip=0&userId=337930'
cms_api = 'http://mbo-cms-api.vs.market.yandex.net/export/widgets?draft=true&page_id={0}&rev={1}&add_wrappers=true'
cms_page_url = 'https://cms.market.yandex.ru/editor/documents/{0}/edit'
widget_relations_api = 'http://mbo-cms-api.vs.market.yandex.net/export/widgets-relations?draft=true&page_id={0}'

emails = ['disamokhvalov', 'aivlapi', 'realtim']
telegrams = ['swoopyyy']


html_template = '''
    <html>
    <head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    </head>
    <body>
    {0}
    </body>
    </html>
'''


def extract_blocks_signatures(obj):
    def _traverse(block):
        outp = []
        hash = []
        if isinstance(block, list):
            for el in block:
                if isinstance(el, dict) or isinstance(el, list):
                    outp_append, hash_append = _traverse(el)
                    outp += outp_append
                    hash += hash_append
                else:
                    hash.append(str(el))
        else:
            for key in block:
                if key == 'name' or key == 'title':
                    if 'text' in block[key]:
                        if isinstance(block[key], str):
                            block_sub = json.loads(block[key])
                        else:
                            block_sub = block[key]
                        if isinstance(block_sub, dict):
                            outp.append(str(block_sub['text']))
                    elif isinstance(block[key], unicode):
                        outp.append(str(block[key]))
                elif isinstance(block[key], dict) or isinstance(block[key], list):
                    outp_append, hash_append = _traverse(block[key])
                    outp += outp_append
                    hash += hash_append

                if key != 'id' and not isinstance(block[key], dict) and not isinstance(block[key], list):
                    hash.append(key + '_' + str(block[key]))

        return outp, hash

    desktop = lambda: obj[0]['content']['rows'][2]['nodes'][0]['props']['main'][0]['nodes'][0]['nodes']
    touch = lambda: obj[0]['content']['rows'][3]['nodes'][0]['nodes']
    mobile = lambda: obj[0]['content']['rows'][0]['nodes'][0]['nodes']
    cms_templates = [desktop, touch, mobile]
    blocks = []
    for templ in cms_templates:
        try:
            blocks = templ()
        except:
            continue

    if not isinstance(blocks, list):
        blocks = []

    result = []
    for block in blocks:
        if isinstance(block, dict):
            sig, hash = _traverse(block)
            m = hashlib.sha256()
            for x in sorted(hash):
                m.update(str(x).encode())
            hash_sha_256 = m.hexdigest()
            if len(sig):
                res = '_'.join(sorted(sig))
                truncate_hash_len = 6
                res += '_' + hash_sha_256[:truncate_hash_len]
                result.append(res)
            else:
                res = 'Нераспознанный блок'
                result.append(res)
        else:
            res = 'Дырка'
            result.append(res)
    return result


class RevisionType(Enum):
    CREATED = 'created'
    UNPUBLISHED = 'unpublished'
    PUBLISHED = 'published'


class Revision:
    def __init__(self, id=None, page_id=None, type=None, timestamp=None, template=None):
        self.id = id
        self.page_id = page_id
        self.type = type
        self.timestamp = timestamp
        self.template = template

    def to_json(self):
        return {
            'id': self.id,
            'page_id': self.page_id,
            'type': self.type.value,
            'timestamp': self.timestamp,
            'template': self.template,
        }

    @classmethod
    def from_json(cls, json_obj):
        return cls(
            id=json_obj['id'],
            page_id=json_obj['page_id'],
            type=RevisionType(json_obj['type']),
            timestamp=json_obj['timestamp'],
            template=json_obj['template'],
        )

    def get_diff(self, other_revision):
        import diff_match_patch as dmp_module

        dmp = dmp_module.diff_match_patch()

        _old = extract_blocks_signatures(json.loads(self.template))
        _new = extract_blocks_signatures(json.loads(other_revision.template))
        line_text_1, line_text_2, line_array = dmp.diff_linesToChars('\n'.join(_old), '\n'.join(_new))
        df = dmp.diff_main(line_text_1, line_text_2, False)
        dmp.diff_charsToLines(df, line_array)
        return df

    @classmethod
    def fetch_and_create(cls, page_id, rev_id=None):
        if rev_id is None:
            revision_response = requests.get(latest_revisions_api.format(str(page_id))).json()['data']['items'][0]
            rev_id = str(revision_response['id'])
            template_response = requests.get(cms_api.format(str(page_id), rev_id)).text
            revision = cls(id=str(rev_id), template=template_response, page_id=str(page_id))

            if 'unpublishedAt' in revision_response:
                revision.type = RevisionType.UNPUBLISHED
                revision.timestamp = revision_response['unpublishedAt']
            elif 'publishedAt' in revision_response:
                revision.type = RevisionType.PUBLISHED
                revision.timestamp = revision_response['publishedAt']
            else:
                revision.type = RevisionType.CREATED
                revision.timestamp = revision_response['createdAt']

            return revision
        else:
            template_response = requests.get(cms_api.format(str(page_id), str(rev_id))).text
            revision = cls(id=str(rev_id), template=template_response, page_id=str(page_id))
            return revision

    def __hash__(self):
        return hash(self.page_id + self.id)


class DjCmsMonitoringLatestCheckedRevisions(sdk2.Resource):
    """Latest checked revisions of cms pages"""

    @classmethod
    def get_latest_revisions(cls):
        latest_revisions_resource = sdk2.Resource.find(
            type="DJ_CMS_MONITORING_LATEST_CHECKED_REVISIONS", state='READY'
        ).first()

        if not latest_revisions_resource:
            return None

        latest_revisions_data = sdk2.ResourceData(latest_revisions_resource)

        with latest_revisions_data.path.open() as fin:
            json_obj = json.load(fin)
            return [Revision.fetch_and_create(str(item[0]), str(item[1])) for item in json_obj['data']]

    @classmethod
    def commit_revisions(cls, revisions, task):
        resource = cls(task, "Latest checked revisions", "latest_revisions.json")
        json_obj = {'data': [[rev.page_id, rev.id] for rev in revisions]}
        resource.path.write_text(unicode(json.dumps(json_obj)))


class DjCmsMonitoringPagesClones(sdk2.Resource):
    """Pages clones"""

    @classmethod
    def get_latest_checked_clones(cls):
        latest_checked_clones = sdk2.Resource.find(type="DJ_CMS_MONITORING_PAGES_CLONES", state='READY').first()

        if not latest_checked_clones:
            return None

        latest_checked_clones_data = sdk2.ResourceData(latest_checked_clones)

        with latest_checked_clones_data.path.open() as fin:
            return json.load(fin)

    @classmethod
    def commit_clones(cls, clones_obj, task):
        resource = cls(task, "Latest checked clones", "latest_clones.json")
        resource.path.write_text(unicode(json.dumps(clones_obj)))

    @classmethod
    def fetch_clones(cls, page_id):
        keys = requests.get(widget_relations_api.format(page_id)).text.split('\n')
        return keys


class DjCmsMonitoringTask(sdk2.Task):

    _current_revisions = []
    _html = ''

    def _add_current_revisions(self, revisions):
        self._current_revisions += revisions

    def _add_html(self, html_code):
        self._html += html_code

    def _format_html(self):
        return html_template.format(self._html)

    def _commit_current_revisions(self):
        DjCmsMonitoringLatestCheckedRevisions.commit_revisions(list(set(self._current_revisions)), self)

    def _get_cms_pages_ids(self):
        cms_pages_ids_resource = sdk2.svn.Arcadia.cat(pages_ids_path)
        return [_id.decode('utf-8') for _id in cms_pages_ids_resource.splitlines()]

    def _get_cms_pages_pairs_ids(self):
        cms_pages_ids_resource = sdk2.svn.Arcadia.cat(pages_pairs_ids_path)
        return [_pair.decode('utf-8').split(',') for _pair in cms_pages_ids_resource.splitlines()]

    def _get_current_revisions(self, page_ids):
        return [Revision.fetch_and_create(page_id) for page_id in page_ids]

    def _diff_list_to_html(self, diff_list, pairs=False):
        def diff_to_rows(diff):
            outp = '<table>'
            for type, df in diff:
                if type == 0:
                    for val in df.split('\n'):
                        outp += '''
                            <tr>
                                <td style="background: lightgray; color: black">{0}</td>
                                <td style="background: lightgray; color: black">{0}</td>
                            </tr>
                        '''.format(
                            val
                        )
                elif type == 1:
                    for val in df.split('\n'):
                        outp += '''
                                <tr>
                                    <td></td>
                                    <td style="background: red; color: white">{0}</td>
                                </tr>
                            '''.format(
                            val
                        )
                else:
                    for val in df.split('\n'):
                        outp += '''
                                <tr>
                                    <td></td>
                                    <td style="background: green; color: white">{0}</td>
                                </tr>
                            '''.format(
                            val
                        )
            outp += '</table>'
            return outp

        body = ''

        if pairs:
            for control_id, test_id, diff in diff_list:
                control_url = cms_page_url.format(control_id)
                test_url = cms_page_url.format(test_id)
                body += 'Между контролем <b><a href="{0}">{1}</a></b> и тестом <b><a href="{2}">{3}</a></b> произошли изменения:<br><br> {4}<br><br>'.format(
                    control_url, control_id, test_url, test_id, diff_to_rows(diff)
                )
        else:
            for page_id, diff in diff_list:
                page_url = cms_page_url.format(page_id)
                body += 'Изменения для <b><a href="{0}">{1}</a></b>:<br><br> {2}<br><br>'.format(
                    page_url, page_id, diff_to_rows(diff)
                )

        return body

    def _clones_diff_to_html(self, diff):
        body = ''

        for page_id in diff:
            page_url = cms_page_url.format(page_id)
            body += 'Для <b><a href="{0}">{1}</a></b> были сделаны следующие клоны: <br><br>'.format(page_url, page_id)
            for clone_key in diff[page_id]:
                body += '<b>{0}</b><br>'.format(clone_key)

        return body

    def _send_email_updates(self):
        if self._html:
            self.server.notification(
                subject="Изменения в CMS страницах",
                body=self._format_html(),
                recipients=emails,
                transport=types.notification.Transport.EMAIL,
                type='html',
            )

    def _monitor_changes(self):
        cms_pages_ids = self._get_cms_pages_ids()
        latest_checked_revs = DjCmsMonitoringLatestCheckedRevisions.get_latest_revisions()
        current_revisions = self._get_current_revisions(cms_pages_ids)

        if not latest_checked_revs:
            self._add_current_revisions(current_revisions)
            return

        latest_checked_revs_mapping = {rev.page_id: rev for rev in latest_checked_revs}
        diff_list = []

        for curr_rev in current_revisions:
            if curr_rev.page_id in latest_checked_revs_mapping:
                latest_rev = latest_checked_revs_mapping[curr_rev.page_id]
                if latest_rev.id != curr_rev.id:
                    diff_list.append((curr_rev.page_id, curr_rev.get_diff(latest_rev)))

        if len(diff_list) != 0:
            html_code = self._diff_list_to_html(diff_list)
            if html_code:
                self._add_html(html_code)

        self._add_current_revisions(current_revisions)

    def _monitor_pairs(self):
        cms_pages_ids_pairs = self._get_cms_pages_pairs_ids()
        latest_checked_revs = DjCmsMonitoringLatestCheckedRevisions.get_latest_revisions()
        current_revisions = self._get_current_revisions([_id for pair in cms_pages_ids_pairs for _id in pair])

        if not latest_checked_revs:
            self._add_current_revisions(current_revisions)
            return

        latest_checked_revs_mapping = {rev.page_id: rev for rev in latest_checked_revs}
        current_revisions_mapping = {rev.page_id: rev for rev in current_revisions}
        diff_list = []

        for control_id, test_id in cms_pages_ids_pairs:
            if control_id in latest_checked_revs_mapping and test_id in latest_checked_revs_mapping:
                current_control_rev = current_revisions_mapping[control_id]
                current_test_rev = current_revisions_mapping[test_id]
                current_diff = current_control_rev.get_diff(current_test_rev)

                latest_control_rev = latest_checked_revs_mapping[control_id]
                latest_test_rev = latest_checked_revs_mapping[test_id]
                latest_diff = latest_control_rev.get_diff(latest_test_rev)

                if len(current_diff) and current_diff != latest_diff:
                    diff_list.append((current_control_rev.page_id, current_test_rev.page_id, current_diff))

        if len(diff_list) != 0:
            html_code = self._diff_list_to_html(diff_list, True)
            if html_code:
                self._add_html(html_code)

        self._add_current_revisions(current_revisions)

    def _monitor_clones(self):
        cms_pages_ids = self._get_cms_pages_ids()
        latest_checked_clones = DjCmsMonitoringPagesClones.get_latest_checked_clones()
        current_clones = {}
        for page_id in cms_pages_ids:
            current_clones[page_id] = DjCmsMonitoringPagesClones.fetch_clones(page_id)

        if latest_checked_clones is None:
            DjCmsMonitoringPagesClones.commit_clones(current_clones, self)
            return

        diff = {}

        for key in current_clones:
            if key in latest_checked_clones:
                df = set(current_clones[key]) - set(latest_checked_clones[key])
                if len(df):
                    diff[key] = df

        html_code = self._clones_diff_to_html(diff)
        if html_code:
            self._add_html(html_code)

        DjCmsMonitoringPagesClones.commit_clones(current_clones, self)

    def on_execute(self):
        self._monitor_changes()
        self._monitor_pairs()
        self._monitor_clones()
        self._send_email_updates()
        self._commit_current_revisions()
