# coding=utf-8
import logging
from sandbox import sdk2


class MarketMarsBaseResource(sdk2.Resource):
    auto_backup = True
    releasable = True
    releasers = ['MARKET']


class MarketMarsBinary(MarketMarsBaseResource):
    """st.yandex-team.ru/MARKETYA-87
    """
    def on_execute(self):
        logging.info('Executing MaRS')


class MarketMarsUnifiedAgentBinary(MarketMarsBaseResource):
    """st.yandex-team.ru/MARKETYA-207
    """
    def on_execute(self):
        logging.info('Executing unified agent with mars config')


class MarketMarsCategoriesWithLevel(MarketMarsBaseResource):
    """st.yandex-team.ru/MARKETYA-490
    """
    def on_execute(self):
        logging.info('Executing categories with level')


class MarketMarsNginxConfig(MarketMarsBaseResource):
    """https://st.yandex-team.ru/MARKETYA-320
    """
    pass


class MarketMarsSwagger(MarketMarsBaseResource):
    """https://st.yandex-team.ru/MARKETYA-320
    """
    pass
