# coding=utf-8
from sandbox import sdk2


market_recom_data_uploaders = [
    'aivlapi',
    'mpdenise',
    'bonv',
    'bbrave',
    'visualmaf',
    'realtim',
    'ismirn0ff',
    'disamokhvalov'
]


class MarketYamarecBaseResource(sdk2.Resource):
    auto_backup = True
    releasable = True
    releasers = ['MARKET']


class MARKET_RECOM_UPLOADED_DATA(MarketYamarecBaseResource):
    """st/MARKETRECOM-1676 st/MARKETRECOM-1647
    """

    releasers = market_recom_data_uploaders
    recom_version = sdk2.parameters.String("Version of hardcoded recommendations")


class MARKET_YAMAREC_UDF_LIB(MarketYamarecBaseResource):
    version = sdk2.parameters.String("Version of Yamarec UDF lib")


class MARKET_YAMAREC_WORD2VEC_MODEL(MarketYamarecBaseResource):
    releasers = ['MARKET_RECOM']


class MARKET_YAMAREC(MarketYamarecBaseResource):
    pass


class MARKET_YAMAREC_NGINX_CONFIG(MarketYamarecBaseResource):
    pass
