# -*- coding: utf-8 -*-

import logging
from sandbox import sdk2
from sandbox.projects.common import task_env
from experiment_dashboard_generator import make_dashboard, publish_dashboard, DAYS


class GenerateExperimentDashboard(sdk2.Task):

    class Requirements(task_env.TinyRequirements):
        pass

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 3600

        number_of_days = sdk2.parameters.Integer(
            'Number of days',
            required=True,
            default=DAYS)

        yav_secret = sdk2.parameters.YavSecret(
            'YAV-секрет с токенами AB_TOKEN и GRAFANA_TOKEN',
            default='sec-01dh8y7fx2yeg0c6mr0p5867qp'
        )

    def on_execute(self):
        tokens = self.Parameters.yav_secret.data()
        grafana_auth_token = tokens['GRAFANA_TOKEN']
        ab_auth_token = tokens['AB_TOKEN']

        dashboard = make_dashboard(self.Parameters.number_of_days, ab_auth_token)
        grafana_output = publish_dashboard(dashboard, grafana_auth_token)
        logging.info('%s', grafana_output)
