# -*- coding: utf-8 -*-

import logging
from sandbox import sdk2
from cluster_metrics_dashboard import make_dashboard, publish_dashboard, REPORT_TYPES
from grafana_host_metric_dashboard import make_dashboard as make_host_metric_dashboard, publish_dashboard as publish_host_metric_dashboard


class GeneratePerHostDashboards(sdk2.Task):

    def on_execute(self):
        grafana_auth_token = sdk2.Vault.data('MARKET', 'grafana_auth_token')
        nanny_auth_token = sdk2.Vault.data('MARKET', 'nanny_auth_token')
        for report_type in REPORT_TYPES:
            dashboard = make_dashboard(report_type, per_host=True, nanny_auth_token=nanny_auth_token, publish=True)
            grafana_output = publish_dashboard(dashboard, report_type, per_host=True, grafana_auth_token=grafana_auth_token)
            logging.info('%s', grafana_output)
        host_metric_dashboard = make_host_metric_dashboard(single_host=True, nanny_auth_token=nanny_auth_token, publish=True)
        grafana_output = publish_host_metric_dashboard(host_metric_dashboard, single_host=True, auth_token=grafana_auth_token)
        logging.info('%s', grafana_output)
