# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.projects.common import solomon

import json
import logging
import requests
import time


class LiteMutedTestsMonitoring(sdk2.Task):

    class Parameters(sdk2.Parameters):
        path = sdk2.parameters.String('Tests directory path', required=True, default='market/report/lite')
        tokens = sdk2.parameters.YavSecret('YAV secret identifier', default='sec-01fbvtsv13fcqh6smmbx4938vm')
        project = sdk2.parameters.String('Solomon project', required=True, default='market-report')
        cluster = sdk2.parameters.String('Solomon cluster', required=True, default='stable')
        service = sdk2.parameters.String('Solomon service', required=True, default='market-report_muted-tests-count')
        label = sdk2.parameters.String('Label on Solomon graph', required=True, default='sensor')

    def on_execute(self):
        tests_stats = self._get_tests_stats()
        sensors = self._create_sensors(tests_stats)
        self._send_signal_to_solomon(sensors)

    def _get_tests_stats(self):
        url = 'http://ci.yandex-team.ru/api/v1.0/tests'
        params = {
            'path': self.Parameters.path,
            'active': 1,
            'limit': 0,
        }
        headers = {
            'Accept': 'application/json'
        }
        res = requests.get(url, params=params, headers=headers).json()

        logging.info('Got response from CI: {}'.format(json.dumps(res, indent=4)))
        return res['tests_stats']

    def _create_sensors(self, tests_stats):
        ts = time.time()
        sensors = [{
            'labels': {self.Parameters.label: key},
            'value': value,
            'ts': ts
        } for key, value in tests_stats.iteritems()]
        logging.info("Created sensors: {}".format(json.dumps(sensors, indent=4)))
        return sensors

    def _send_signal_to_solomon(self, sensors):
        oauth = self.Parameters.tokens.data()['solomon-oauth']
        params = {
            'project': self.Parameters.project,
            'cluster': self.Parameters.cluster,
            'service': self.Parameters.service,
        }
        solomon.push_to_solomon_v2(token=oauth, params=params, sensors=sensors)
