from sandbox import sdk2
from sandbox.projects.common import binary_task


class MarketDauCapacityPredictor(binary_task.LastBinaryTaskRelease, sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        ext_params = binary_task.binary_release_parameters(stable=True)

        tokens = sdk2.parameters.YavSecret('YAV secret identifier (with optional version)')
        yt_token_name = sdk2.parameters.String('YT token name', default='yt_token')
        stat_token_name = sdk2.parameters.String('Stat token name', default='stat_token')
        yql_token_name = sdk2.parameters.String('YQL token name', default='yql_token')

    def on_execute(self):
        from market.tools.dau_capacity.dau_capacity_predictor import DauCapacityPredictor

        binary_task.LastBinaryTaskRelease.on_execute(self)
        tokens = self.Parameters.tokens.data()
        yt_token = tokens[self.Parameters.yt_token_name]
        stat_token = tokens[self.Parameters.stat_token_name]
        yql_token = tokens[self.Parameters.yql_token_name]
        predictor = DauCapacityPredictor(yt_token, stat_token, yql_token)
        predictor.predict_and_update()
