import os

from sandbox import sdk2

from sandbox.projects.market.report.common.stat import LOG_DIR, calc

DIFF_FILE_TEMPLATE = 'See result diff file: <a href="{}/diff.out.log">diff.out.log</a>'


class StatParameters(sdk2.Parameters):
    inputs = sdk2.parameters.List('Stat input tables', default=[LOG_DIR], required=True)
    begin = sdk2.parameters.String('Begin time interval', default='2000-01-01T08:30:00', required=True)
    end = sdk2.parameters.String('End time interval', default='2999-12-28T23:59:59', required=True)
    advanced = sdk2.parameters.List('Advanced arguments', description='Try --help')


class MarketReportCalcDiff(sdk2.Task):
    """Calc log cgi parameters diff"""

    class Parameters(sdk2.Parameters):
        description = "Calc log cgi parameters diff"
        kill_timeout = 20 * 60  # seconds

        tokens = sdk2.parameters.YavSecret(
            'YAV secret identifier (with optional version)', default='sec-01fd9apjvrv3j38wne5wjwvdhp', required=True
        )
        yt_token_name = sdk2.parameters.String('YT token name', default='yt-token', required=True)

        cluster = sdk2.parameters.String('Cluster', default='arnold', required=True)

        sdk2.helpers.set_parameter('first_stat', StatParameters(prefix='first_'))
        sdk2.helpers.set_parameter('second_stat', StatParameters(prefix='second_'))

    def get_yt_path(self, table_name):
        return '//tmp/' + self.author + '/' + table_name

    def calc_stat(self, prefix):
        stat = self.Parameters.__dict__['__values__']
        inputs = ['-i {}'.format(table) for table in stat[prefix + 'inputs']]
        advanced = stat[prefix + 'advanced']
        advanced += ['-b {}'.format(stat[prefix + 'begin']), '-e {}'.format(stat[prefix + 'end'])]
        output = self.get_yt_path(prefix)
        calc(self, self.Parameters.cluster, inputs, output, advanced, 'stat')
        return output

    def on_execute(self):
        tokens = self.Parameters.tokens.data()
        os.environ['YT_TOKEN'] = tokens[self.Parameters.yt_token_name]

        cluster = self.Parameters.cluster

        first = self.calc_stat('first_')
        second = self.calc_stat('second_')

        inputs = ['--first', first, '--second', second]
        output = self.get_yt_path('diff_')
        calc(self, cluster, inputs, output, ['-p'], 'diff')

        self.set_info(DIFF_FILE_TEMPLATE.format(self.log_resource.http_proxy), False)
