from sandbox.common.types.client import Tag
from sandbox.projects.common.build import parameters as build_parameters
from sandbox.projects.market.report.MarketReportRelease import MarketReportRelease
from sandbox.projects.market.report.MarketReportGenerateChangelog import svn, generate_changelog

from sandbox.sandboxsdk.parameters import SandboxStringParameter


class BuildVersionParameter(SandboxStringParameter):
    name = 'build_version'
    description = 'Build version'


class MarketReportCdRelease(MarketReportRelease, object):
    type = 'MARKET_REPORT_CD_RELEASE'

    input_parameters = MarketReportRelease.input_parameters + [BuildVersionParameter]
    client_tags = \
        MarketReportRelease.client_tags \
        & (Tag.CORES56 | Tag.CORES64 | Tag.CORES80) \
        & (Tag.LINUX_TRUSTY | Tag.LINUX_XENIAL | Tag.LINUX_BIONIC)

    def on_prepare(self):
        branch_path = self.ctx['checkout_arcadia_from_url']
        at_index = branch_path.index('@')
        if at_index >= 0:
            branch_path = branch_path[:at_index]

        build_version = self.ctx['build_version']
        package_name = self.ctx['packages']
        package_name = package_name[package_name.rfind('/')+1:package_name.rfind('.')]
        ya_package_patch = svn.patch_ya_package_version(branch_path, build_version, should_commit=False, package_name=package_name)

        changelog_content = generate_changelog(build_version, build_version, [], package_name=package_name)
        _, changelog_patch = svn.update_changelog(branch_path, changelog_content, should_commit=False)

        self.ctx['arcadia_patch'] = ya_package_patch + '\n' + changelog_patch

        super(MarketReportCdRelease, self).on_prepare()
