import jinja2
import datetime

CHANGELOG_TEMPLATE = '''{{package}} ({{version}}) trusty; urgency=medium

* {{ticket}} Release {{release}}
{%- for market_commit in market_commits %}
    *  {{market_commit.message}}. Revision: {{market_commit.revision}} ({{market_commit.author}})
{%- endfor %}

-- {{fullname}} <{{mail}}>  {{date}}
'''


def generate_changelog(build_version, report_version, commits, package_name='yandex-market-report'):
    change_log_template = jinja2.Template(CHANGELOG_TEMPLATE)
    current_date = datetime.datetime.now()
    changelog_content = change_log_template.render(version=build_version,
                                                   ticket='MARKETOUT-0000',
                                                   release=report_version,
                                                   fullname='robot-market-st',
                                                   mail='robot-market-st@yandex-team.ru',
                                                   date=current_date.strftime('%a, %d %b %Y %H:%M:%S +0300'),
                                                   market_commits=commits,
                                                   package=package_name)
    return changelog_content
