import json
import logging
from sandbox import sdk2
from sandbox.projects import resource_types


class MarketReportMoneyDiffResult(sdk2.Resource):
    """
    Result of comparision
    """


class MarketReportMoneyDiff(sdk2.Task):
    """ Compare output of two TEST_MARKET_REPORT_MONEY tasks and say whether they have diff or not """

    class Parameters(sdk2.Task.Parameters):
        test1_results = sdk2.parameters.Resource(
            "Test1 results",
            resource_type=resource_types.TEST_MARKET_REPORT_MONEY_RESULT_JSON,
            required=True,
        )
        test2_results = sdk2.parameters.Resource(
            "Test1 results",
            resource_type=resource_types.TEST_MARKET_REPORT_MONEY_RESULT_JSON,
            required=True,
        )

    class Context(sdk2.Task.Context):
        pass

    def on_execute(self):
        logging.info("Starting comparision")
        test1_res = json.loads(sdk2.ResourceData(self.Parameters.test1_results).path.read_bytes())
        test2_res = json.loads(sdk2.ResourceData(self.Parameters.test2_results).path.read_bytes())
        avg1 = test1_res[1]["click_price"]["avg"]
        avg2 = test2_res[1]["click_price"]["avg"]
        k = abs(avg1 - avg2) / avg2 if avg2 != 0 else 1.0
        has_diff = k >= 0.01
        res = {
            "k": k,
            "has_diff": has_diff,
            "test1_res": test1_res,
            "test2_res": test2_res,
        }
        self.Context.has_diff = has_diff
        data = sdk2.ResourceData(MarketReportMoneyDiffResult(self, "The diff", "result.json"))
        data.path.write_bytes(json.dumps(res, indent=4))
        data.ready()
