import logging
from subprocess import Popen, PIPE
from random import random
from sandbox import sdk2


class TestAccessFromSandboxToHost(sdk2.Task):
    """ Test access to host """

    class Parameters(sdk2.Task.Parameters):
        hostname = sdk2.parameters.String("hostname", required=True)

        description = "Test access to host"

    def on_execute(self):
        filename = "file_{}".format(random())
        logging.info('creating temporary file {}'.format(filename))
        with open(filename, "w") as file:
            file.write("Hello world!")
        logging.info('sending file via scp')
        p = Popen(['scp', '-vvv', filename, self.Parameters.hostname + ':/tmp/{}'.format(filename)], stdout=PIPE, stderr=PIPE, bufsize=1)
        for line in iter(p.stdout.readline, ''):
            logging.info("subprocess stdout line: {}".format(line))
        for line in iter(p.stderr.readline, ''):
            logging.info("subprocess stderr line: {}".format(line))
        p.stdout.close()
        p.stderr.close()
        if p.wait() != 0:
            raise RuntimeError("failed, exit status: %d" % (p.returncode))
        logging.info("success")
