# -*- coding: utf-8 -*-

from enum import Enum


class Metric:
    def __init__(self, id, name, plan=None, current=None, previous=None, unit=None, periods=None, period=None, more=True):
        self._id = id
        self._name = name
        self._plan = plan
        self._current = current
        self._previous = previous
        self._unit = unit
        self._more = more
        self._periods = periods
        self._previous_period = period

    def __repr__(self):
        return "Metric(id={id}, name={name})".format(
            id=self._id,
            name=self._name,
        )


class MetricGroup:
    def __init__(self, id, name, metrics):
        self._id = id
        self._name = name
        self._metrics = metrics

    def __repr__(self):
        return "MetricGroup(id={id}, name={name}, metrics={metrics})".format(
            id=self._id,
            name=self._name,
            metrics=self._metrics
        )


class MetricStream:
    def __init__(self, id, name, groups):
        self._id = id
        self._name = name
        self._groups = groups

    def __repr__(self):
        return "MetricStream(id={id}, name={name}, groups={groups})".format(
            id=self._id,
            name=self._name,
            groups=self._groups
        )


class Resource:
    def __init__(self, id, resource_type, source, resource_refs):
        self._id = id
        self._resource_type = resource_type
        self._source = source
        self._resource_refs = resource_refs


class ResourceRef:
    def __init__(self, metric, positions):
        self._metric = metric
        self._positions = positions


class MetricPeriod(Enum):
    ONE_DAY = 'ONE_DAY'
    ONE_WEEK = 'ONE_WEEK'

    def __str__(self):
        return self.value


class StabilityMetric:
    def __init__(self, name, downtimes):

        days = 1

        # sec of metric_period in days
        period = 60 * 60 * 24 * days

        over = reduce(lambda sum, downtime: sum + downtime, downtimes)

        self._name = name
        self._plan = 99.5

        self._over = round(over / 60)
        self._sla = round((period - over) / period * 100, 2)
        # self.mttf = round(period / len(downtimes), 2)
        # self.mttr = round(self.sli / len(downtimes), 2)
        # self.mtbf = round((period - self.sli) / len(downtimes), 2)

