USE marketclickhouse;

SELECT
    period_start,
    round(count_500 / count_all * 100, 2) as percent_of_5xx
FROM (
    SELECT
        date as period_start,
        COUNT(*) as count_500
    FROM
        market.market_errors
    PREWHERE
        period_start = today() - {delta_in_days}
        AND environment = 'PRODUCTION'
        AND service = 'market_tpl_front'
        AND code = 'RemoteResolverError'
    WHERE
        message LIKE 'tpl/courierPlatform/%'
        AND (message LIKE '%getCompany'
        OR message LIKE '%getOrder'
        OR message LIKE '%getDropshipOrder'
        OR message LIKE '%getOrders'
        OR message LIKE '%getScheduleRules'
        OR message LIKE '%getSlotsForSc'
        OR message LIKE '%getShifts'
        OR message LIKE '%getUserShifts'
        OR message LIKE '%getShiftsData'
        OR message LIKE '%getShiftsEQueue'
        OR message LIKE '%getTransportsV2'
        OR message LIKE '%getUser'
        OR message LIKE '%getUsers'
        OR message LIKE '%getClientReturnOrder'
        OR message LIKE '%cancelDropship'
        OR message LIKE '%reopenDropship'
        OR message LIKE '%cancelOrder'
        OR message LIKE '%reopenOrder'
        OR message LIKE '%changeOrderData'
        OR message LIKE '%addScheduleRule'
        OR message LIKE '%deleteScheduleRule'
        OR message LIKE '%editScheduleRule'
        OR message LIKE '%addUser'
        OR message LIKE '%updateUser')
    GROUP BY
        period_start
) as c500
JOIN (
    SELECT
        date as period_start,
        SUM(length(splitByChar('&', url))) as count_all
    FROM
        market.tpl_front_nginx
    PREWHERE
        period_start = today() - {delta_in_days}
        and page_id = 'api:resolve' --поднял в PREWHERE
    WHERE
        url LIKE '%tpl/courierPlatform/%'
        AND (
            url like '%getCompany%' OR
            url like '%getOrder%' OR
            url like '%getDropshipOrder%' OR
            url like '%getOrders%' OR
            url like '%getScheduleRules%' OR
            url like '%getSlotsForSc%' OR
            url like '%getShifts%' OR
            url like '%getUserShifts%' OR
            url like '%getShiftsData%' OR
            url like '%getShiftsEQueue%' OR
            url like '%getTransportsV2%' OR
            url like '%getUser%' OR
            url like '%getUsers%' OR
            url like '%getClientReturnOrder%' OR
            url like '%cancelDropship%' OR
            url like '%reopenDropship%' OR
            url like '%cancelOrder%' OR
            url like '%reopenOrder%' OR
            url like '%changeOrderData%' OR
            url like '%addScheduleRule%' OR
            url like '%deleteScheduleRule%' OR
            url like '%editScheduleRule%' OR
            url like '%addUser%' OR
            url like '%updateUser%'
        )
    GROUP BY
        period_start
) AS c200 ON c500.period_start = c200.period_start
;
