USE marketclickhouse;

SELECT
    c200_ajax.period_start,
    round((c500_ajax.count_500 + c500_html.count_500) / (c200_ajax.count_all + c200_html.count_all) * 100, 2) as percent_of_5xx
FROM (
    SELECT
        date as period_start,
        SUM(length(splitByChar('&', url))) as count_all
    FROM
        (
            SELECT
                date,
                url,
                page_id,
                http_code
            FROM
                market.tpl_front_nginx
            PREWHERE
                date = today() - {delta_in_days}
        )
    WHERE
        page_id = 'api:resolve'
        AND url LIKE '/api/resolve/?r=tpl/outlets/%'
        AND (
            -- приемка
            url LIKE '%createTplOutletShipment%'
            OR url LIKE '%getTplOutletOrders%'
            -- выдача
            OR url LIKE '%deliverTplOutletOrder%'
            OR url LIKE '%getTplOutletOrder%'
            OR url LIKE '%getTplOutletOrders%'
            OR url LIKE '%getTplOutletOrderForm%'
            -- отгрузка
            OR url LIKE '%createTplOutletShipment%'
            OR url LIKE '%getTplOutletDispatchShipmentsSummary%'
            OR url LIKE '%getTplOutletOrdersToDispatch%'
            -- приемка возвратов
            OR url LIKE '%getTplOutletReturnRequestsBarcode%'
            OR url LIKE '%getTplOutletReturnRequests%'
            -- фешн
            OR url LIKE '%updateTplOutletOrderPartialDeliverFlow%'
            OR url LIKE '%createTplOutletOrderPartialDeliverSafePackage%'
            OR url LIKE '%deleteTplOutletOrderPartialDeliverSafePackage%'
            OR url LIKE '%generateTplOutletOrderPartialDeliverSafePackageBarcode%'
            OR url LIKE '%updateTplOutletOrderPackageStatusCreate%'
            OR url LIKE '%updateTplOutletOrderPackageStatusFittingDone%'
            OR url LIKE '%updateTplOutletOrderPackageStatusBackToFitting%'
            OR url LIKE '%updateTplOutletOrderPackageStatusPackaged%'
            OR url LIKE '%updateTplOutletOrderPackageStatusFullReturnToPackage%'
            OR url LIKE '%updateTplOutletOrderPartialDeliverReturnReason%'
        )
    GROUP BY
        period_start
) AS c200_ajax
JOIN (
    SELECT
        date as period_start,
        COUNT(*) as count_all
    FROM
        (
            SELECT
                date,
                url,
                page_id,
                http_code
            FROM
                market.tpl_front_nginx
            PREWHERE
                date = today() - {delta_in_days}
        )
    WHERE
        page_id IN (
            -- приемка
            'market-partner:file:tpl-outlet-reception-shipments-act:get',
            -- отгрузка
            'market-partner:file:tpl-outlet-dispatch-shipments-act:get',
            -- приемка возвратов
            'market-partner:file:tpl-outlet-return-requests-download-app:get'
        )
    GROUP BY
        period_start
) AS c200_html ON c200_html.period_start = c200_ajax.period_start
JOIN (
    SELECT
        date as period_start,
        COUNT(*) as count_500
    FROM
        market.market_errors
    PREWHERE
        date = today() - {delta_in_days}
        AND service = 'market_tpl_front'
        AND environment = 'PRODUCTION'
    WHERE
        code = 'RemoteResolverError'
        AND (
            -- приемка
            message LIKE 'tpl/outlets/createTplOutletShipment%'
            OR message LIKE 'tpl/outlets/getTplOutletOrders%'
            -- выдача
            OR message LIKE 'tpl/outlets/deliverTplOutletOrder%'
            OR message LIKE 'tpl/outlets/getTplOutletOrder%'
            OR message LIKE 'tpl/outlets/getTplOutletOrders%'
            OR message LIKE 'tpl/outlets/getTplOutletOrderForm%'
            -- отгрузка
            OR message LIKE 'tpl/outlets/createTplOutletShipment%'
            OR message LIKE 'tpl/outlets/getTplOutletDispatchShipmentsSummary%'
            OR message LIKE 'tpl/outlets/getTplOutletOrdersToDispatch%'
            -- приемка возвратов
            OR message LIKE 'tpl/outlets/getTplOutletReturnRequestsBarcode%'
            OR message LIKE 'tpl/outlets/getTplOutletReturnRequests%'
            -- фешн
            OR message LIKE 'tpl/outlets/updateTplOutletOrderPartialDeliverFlow%'
            OR message LIKE 'tpl/outlets/createTplOutletOrderPartialDeliverSafePackage%'
            OR message LIKE 'tpl/outlets/deleteTplOutletOrderPartialDeliverSafePackage%'
            OR message LIKE 'tpl/outlets/generateTplOutletOrderPartialDeliverSafePackageBarcode%'
            OR message LIKE 'tpl/outlets/updateTplOutletOrderPackageStatusCreate%'
            OR message LIKE 'tpl/outlets/updateTplOutletOrderPackageStatusFittingDone%'
            OR message LIKE 'tpl/outlets/updateTplOutletOrderPackageStatusBackToFitting%'
            OR message LIKE 'tpl/outlets/updateTplOutletOrderPackageStatusPackaged%'
            OR message LIKE 'tpl/outlets/updateTplOutletOrderPackageStatusFullReturnToPackage%'
            OR message LIKE 'tpl/outlets/updateTplOutletOrderPartialDeliverReturnReason%'
        )
    GROUP BY
        period_start
) as c500_ajax ON c500_ajax.period_start = c200_html.period_start
LEFT JOIN (
    SELECT
        date as period_start,
        COUNT(*) as count_500
    FROM
        (
            SELECT
                date,
                url,
                page_id,
                http_code
            FROM
                market.tpl_front_nginx
            PREWHERE
                date = today() - {delta_in_days}
        )
    WHERE
        http_code >= 500 AND http_code <= 599
        AND page_id IN (
            -- приемка
            'market-partner:file:tpl-outlet-reception-shipments-act:get',
            -- отгрузка
            'market-partner:file:tpl-outlet-dispatch-shipments-act:get',
            -- приемка возвратов
            'market-partner:file:tpl-outlet-return-requests-download-app:get'
        )
    GROUP BY
        period_start
) as c500_html ON c500_ajax.period_start = c500_html.period_start;
