USE marketclickhouse;

SELECT
    c200_ajax.period_start,
    round((c500_ajax.count_500 + c500_html.count_500) / (c200_ajax.count_all + c200_html.count_all) * 100, 2) as percent_of_5xx
FROM (
    SELECT
        date as period_start,
        COUNT(*) as count_500
    FROM
        market.market_errors
    PREWHERE
        period_start = today() - {delta_in_days}
        AND service = 'market_tpl_front'
    WHERE
        environment = 'PRODUCTION'
        AND code = 'RemoteResolverError'
        AND (
            -- ячейки
            message LIKE 'sortingCenter/cells/getCells%'
            OR message LIKE 'sortingCenter/cells/createCell%'
            OR message LIKE 'sortingCenter/cells/getCellSubTypes%'
            OR message LIKE 'sortingCenter/cells/getCellTypes%'
            OR message LIKE 'sortingCenter/couriers/getMidMilesCouriers%'
            OR message LIKE 'sortingCenter/warehouses/getWarehouses%'
            OR message LIKE 'sortingCenter/zones/getZones%'
            -- список заказов
            OR message LIKE 'sortingCenter/orders/getOrders%'
            OR message LIKE 'sortingCenter/orders/getOrdersCommonFilterOptions%'
            OR message LIKE 'sortingCenter/orders/getOrdersCourierFilterOptions%'
            OR message LIKE 'sortingCenter/orders/getOrdersDispatchPersonFilterOptions%'
            -- заказ
            OR message LIKE 'sortingCenter/orders/getOrder%'
            OR message LIKE 'sortingCenter/orders/getOrderEvents%'
            OR message LIKE 'sortingCenter/orders/markAsDamagedOrder%'
            -- маршруты
            OR message LIKE 'sortingCenter/routes/getRoutesMainInfo%'
            OR message LIKE 'sortingCenter/routes/getRoutesPage%'
            OR message LIKE 'sortingCenter/routes/getRoutesPage%'
            OR message LIKE 'sortingCenter/routes/getRoutesFullInfo%'
            OR message LIKE 'sortingCenter/lots/shipLots%'
        )
    GROUP BY
        period_start
) as c500_ajax
JOIN (
    SELECT
        date as period_start,
        SUM(length(splitByChar('&', url))) as count_all
    FROM
        (
            SELECT
                date,
                url,
                page_id,
                http_code
            FROM
                market.tpl_front_nginx
            PREWHERE
                date = today() - {delta_in_days}
        )
    WHERE
        page_id = 'api:resolve'
        AND url LIKE '/api/resolve/?r=sortingCenter/%'
        AND (
             -- ячейки
            url LIKE '%getCells%'
            OR url LIKE '%createCell%'
            OR url LIKE '%getCellSubTypes%'
            OR url LIKE '%getCellTypes%'
            OR url LIKE '%getMidMilesCouriers%'
            OR url LIKE '%getWarehouses%'
            OR url LIKE '%getZones%'
            -- список заказов
            OR url LIKE '%getOrders%'
            OR url LIKE '%getOrdersCommonFilterOptions%'
            OR url LIKE '%getOrdersCourierFilterOptions%'
            OR url LIKE '%getOrdersDispatchPersonFilterOptions%'
            -- заказ
            OR url LIKE '%getOrder%'
            OR url LIKE '%getOrderEvents%'
            OR url LIKE '%markAsDamagedOrder%'
            -- маршруты
            OR url LIKE '%getRoutesMainInfo%'
            OR url LIKE '%getRoutesPage%'
            OR url LIKE '%getRoutesPage%'
            OR url LIKE '%getRoutesFullInfo%'
            OR url LIKE '%shipLots%'
        )
    GROUP BY
        period_start
) AS c200_ajax ON c500_ajax.period_start = c200_ajax.period_start
JOIN (
    SELECT
        date as period_start,
        COUNT(*) as count_all
    FROM
        (
            SELECT
                date,
                url,
                page_id,
                http_code
            FROM
                market.tpl_front_nginx
            PREWHERE
                date = today() - {delta_in_days}
        )
    WHERE
        page_id IN (
            -- список заказов
            'market-partner:file:sorting-center-order-list:get',
            -- заказ
            'market-partner:file:sorting-center-order-statuses:get',
            -- маршруты
            'market-partner:file:sorting-center-routes-return-pallet:get',
            'market-partner:file:sorting-center-routes-return-registry:get',
            'market-partner:file:sorting-center-routes-transfer-act:get'
        )
    GROUP BY
        period_start
) AS c200_html ON c200_html.period_start = c200_ajax.period_start
LEFT JOIN (
    SELECT
        date as period_start,
        COUNT(*) as count_500
    FROM
        (
            SELECT
                date,
                url,
                page_id,
                http_code
            FROM
                market.tpl_front_nginx
            PREWHERE
                date = today() - {delta_in_days}
        )
    WHERE
        http_code >= 500 AND http_code <= 599
        AND page_id IN (
            -- список заказов
            'market-partner:file:sorting-center-order-list:get',
            -- заказ
            'market-partner:file:sorting-center-order-statuses:get',
            -- маршруты
            'market-partner:file:sorting-center-routes-return-pallet:get',
            'market-partner:file:sorting-center-routes-return-registry:get',
            'market-partner:file:sorting-center-routes-transfer-act:get'
        )
    GROUP BY
        period_start
) as c500_html ON c500_ajax.period_start = c500_html.period_start
