USE marketclickhouse;

SELECT
    d.period_start,
    ifNull(cs.diff_items, 0) + d.diff_items,
    ifNull(cs.diff_orders, 0) + d.diff_orders
FROM
(
    SELECT
        period_start,
        sumIf(diff, unit_type = 'ITEM') as diff_items,
        sumIf(diff, unit_type = 'ORDER') as diff_orders
    FROM (
        SELECT
            date as period_start,
            extra_values[indexOf(extra_keys, 'unitType')] as unit_type,
            extra_values[indexOf(extra_keys, 'partnerId')] as partner_id,
            extra_values[indexOf(extra_keys, 'day')] as day,
            argMax(CAST(extra_values[indexOf(extra_keys, 'diff')] as UInt32), timestamp) as diff
        FROM market.logistics_backlog_tskv
        WHERE period_start = today() - {delta_in_days}
        AND environment = 'PRODUCTION'
        AND has(tags, 'CAPACITY_OVERFLOW')
        AND extra_values[indexOf(extra_keys, 'reason')] = 'NEW_ORDER'
        GROUP BY period_start, unit_type, partner_id, day
    )
    GROUP BY period_start
) AS cs
RIGHT JOIN (
    SELECT
        today() - {delta_in_days} period_start,
        0 diff_items,
        0 diff_orders
) AS d ON cs.period_start = d.period_start
;
