USE marketclickhouse;

SELECT period_start,
       ROUND(SUM(page_count / total_count * resp_95), 2) AS weighted_resp_95
FROM (
         SELECT date as period_start,
                COUNT(*)       AS total_count
         FROM market.carrier_driver_nginx
         WHERE period_start = today() - {delta_in_days}
           AND environment = 'PRODUCTION'
           AND page_id LIKE '%api%'
         GROUP BY
             period_start
     ) AS total
     JOIN (
    SELECT toMonday(date)              AS period_start,
           page_id,
           quantile(0.95)(resptime_ms) AS resp_95,
           COUNT(*)                    AS page_count
    FROM market.carrier_driver_nginx
    WHERE period_start = today() - {delta_in_days}
      AND environment = 'PRODUCTION'
      AND page_id LIKE '%api%'
    GROUP BY
        period_start,
        page_id
) AS page ON page.period_start = total.period_start
GROUP BY period_start
ORDER BY period_start DESC;
