USE marketclickhouse;

SELECT
    date as period_start,
    grpc_method,
    round(quantile(0.99)(grpc_time_ms), 2) AS resp_99
FROM
    `market`.`combinator_grpc`
WHERE
    period_start = today() - {delta_in_days}
    AND grpc_method in ('GetCourierOptions', 'GetDeliveryRoute', 'GetOffersDeliveryStatsOne')
GROUP BY
    period_start,
    grpc_method
ORDER BY
    period_start DESC,
    grpc_method ASC;
