USE marketclickhouse;

SELECT
    period_start,
    round(SUM(page_count / total_count * resp_95), 2) AS weighted_resp_95
FROM (
    SELECT
        date as period_start,
        count(*) as total_count
    FROM
        market.tpl_front_nginx
    PREWHERE
        period_start = today() - {delta_in_days}
    WHERE (
        page_id LIKE 'market-partner:html:tpl-transport%:get'
        OR page_id LIKE 'market-partner:html:tpl-courier%:get'
        OR page_id LIKE 'market-partner:html:tpl-company%:get'
        OR page_id LIKE 'market-partner:html:tpl-client%:get'
        OR page_id LIKE 'market-partner:html:tpl-dropship%:get'
        OR page_id LIKE 'market-partner:html:tpl-shift%:get'
        OR page_id LIKE 'market-partner:html:tpl-schedule%:get'
        OR page_id LIKE 'market-partner:html:tpl-routing%:get'
        OR page_id LIKE 'market-partner:html:tpl-report%:get'
        OR page_id LIKE 'market-partner:html:tpl-forecast%:get'
        OR page_id LIKE 'market-partner:html:tpl-order%:get'
    )
    GROUP BY
        period_start
) as total
JOIN (
    SELECT
        date as period_start,
        page_id,
        quantile(0.95)(resptime_ms) AS resp_95,
        count(*) as page_count
    FROM
        market.tpl_front_nginx
    PREWHERE
        period_start = today() - {delta_in_days}
    WHERE (
        page_id LIKE 'market-partner:html:tpl-transport%:get'
        OR page_id LIKE 'market-partner:html:tpl-courier%:get'
        OR page_id LIKE 'market-partner:html:tpl-company%:get'
        OR page_id LIKE 'market-partner:html:tpl-client%:get'
        OR page_id LIKE 'market-partner:html:tpl-dropship%:get'
        OR page_id LIKE 'market-partner:html:tpl-shift%:get'
        OR page_id LIKE 'market-partner:html:tpl-schedule%:get'
        OR page_id LIKE 'market-partner:html:tpl-routing%:get'
        OR page_id LIKE 'market-partner:html:tpl-report%:get'
        OR page_id LIKE 'market-partner:html:tpl-forecast%:get'
        OR page_id LIKE 'market-partner:html:tpl-order%:get'
        OR page_id LIKE 'market-partner:html:tpl-transaction%:get'
    )
    GROUP BY
        period_start,
        page_id
) as page ON page.period_start = total.period_start
GROUP BY
    period_start
ORDER BY
    period_start ASC;
