use mtch;

WITH 1.0 AS W
SELECT `ym:cr2:date`                                                             AS period_start,
       round((1.0 - `ym:cr:uniqCrashSession` / `ym:ge:uniqAnySession`) * 100, 2) AS crashesFreeSessionsPercentage,
       round((1.0 - least(`ym:cr:uniqCrashDevice`, `ym:cr:sumCrashEventTypes`) /
                    `ym:ge:uniqDeviceIDHash`) * 100, 2)                          AS crashesFreeDevicesPercentage
FROM (WITH 1.0 AS W
      SELECT EventDate                                 AS `ym:cr2:date`,
             uniq((UUIDHash, DeviceIDHash, SessionID)) AS `ym:cr:uniqCrashSession`,
             uniq(DeviceIDHash)                        AS `ym:cr:uniqCrashDevice`,
             sum(Sign)                                 AS `ym:cr:sumCrashEventTypes`
      FROM mobgiga.crash_events_all as `mobile.total_crash_events_layer`
      WHERE `ym:cr2:date` = today() - {delta_in_days}
        and APIKey = 3238045
        and EventType IN (3, 26)
        and toString(OperatingSystem) = 'android'
      GROUP BY `ym:cr2:date`
      WITH TOTALS
      HAVING `ym:cr:sumCrashEventTypes` > toInt8(0)) global any
         left join (WITH 1.0 AS W
                    SELECT EventDate                                 AS `ym:cr2:date`,
                           uniq((UUIDHash, DeviceIDHash, SessionID)) AS `ym:ge:uniqAnySession`,
                           uniq(DeviceIDHash)                        AS `ym:ge:uniqDeviceIDHash`
                    FROM mobgiga.generic_events_all as `mobile.generic_events_layer`
                    WHERE `ym:cr2:date` = today() - {delta_in_days}
                      and APIKey = 3238045
                      and toString(OperatingSystem) = 'android'
                    GROUP BY `ym:cr2:date`
                    WITH TOTALS ) using `ym:cr2:date`
limit 1
