use marketclickhouse;

SELECT
    date as period_start,
    round(quantileExact(0.98)(toUInt64OrZero(extra_values[indexOf(extra_keys, 'delayMSec')])) / 60000) AS over_min,
    ifNull(nullIf(extra_values[indexOf(extra_keys, 'executor')], ''), 'unknown') AS executor
FROM market.logistics_backlog_tskv
WHERE period_start = today() - {delta_in_days}
AND code='PROCESSOR_DELAY'
AND environment = 'PRODUCTION'
AND service = 'market_logistics_mqm'
AND executor in ('PlanFactGroupHandlerImpl', 'PlanFactHandlerImpl')
AND has(extra_keys, 'delayMSec')
GROUP BY period_start, executor
ORDER BY period_start DESC, executor
;
