use marketclickhouse;

SELECT
    date as period_start,
    round(quantile(0.99)(toUInt64OrZero(extra_values[indexOf(extra_keys, 'executionTime')])) / 60000, 2) AS duration,
    ifNull(nullIf(extra_values[indexOf(extra_keys, 'executor')], ''), 'unknown') AS executor
FROM market.logistics_backlog_tskv
WHERE period_start = today() - {delta_in_days}
AND environment = 'PRODUCTION'
AND service = 'market_logistics_lom'
AND has(tags, 'WAYBILL_SEGMENT_PLAN_FACT_PROCESSING_METRICS')
AND has(extra_keys, 'executionTime')
AND has([
        'ProcessAggregatedWaybillSegmentPlanFactDeadlinesExecutor',
        'ProcessWaybillSegmentPlanFactDeadlinesExecutor'
    ], ifNull(nullIf(extra_values[indexOf(extra_keys, 'executor')], ''), 'unknown'))
GROUP BY period_start, executor
ORDER BY period_start DESC, executor;
