use marketclickhouse;

SELECT
    period_start,
    executor,
    round(sum(over)/60) as over_min
FROM
(
    SELECT
        period_start,
        a.start,
        min(b.start - a.start) as delta,
        greatest(delta - 1200, 0) as over,
        a.executor as executor
    FROM
    (
        SELECT
            date as period_start,
            toDateTime(timestamp - (duration / 1000) + 1) as start,
            toUInt32(ifNull(nullIf(extra_values[indexOf(extra_keys, 'executionTime')], ''), 'unknown')) as duration,
            ifNull(nullIf(extra_values[indexOf(extra_keys, 'executor')], ''), 'unknown') AS executor
        FROM market.logistics_backlog_tskv
        WHERE (period_start = today() - {delta_in_days} )
        AND environment = 'PRODUCTION'
        AND service = 'market_logistics_mqm'
        AND has(tags, 'PLAN_FACT_PROCESSING_METRICS')
        AND has(extra_keys, 'executionTime')
        AND has([
            'ProcessAggregatedPlanFactDeadlinesExecutor',
            'ProcessPlanFactDeadlinesExecutor'
        ], ifNull(nullIf(extra_values[indexOf(extra_keys, 'executor')], ''), 'unknown'))
        ORDER BY timestamp ASC
    ) AS a
    JOIN
    (
        SELECT
            date as period_start,
            toDateTime(timestamp - (duration / 1000) + 1) as start,
            toUInt32(ifNull(nullIf(extra_values[indexOf(extra_keys, 'executionTime')], ''), 'unknown')) as duration,
            ifNull(nullIf(extra_values[indexOf(extra_keys, 'executor')], ''), 'unknown') AS executor
        FROM market.logistics_backlog_tskv
        WHERE (period_start = today() - {delta_in_days} )
        AND environment = 'PRODUCTION'
        AND service = 'market_logistics_mqm'
        AND has(tags, 'PLAN_FACT_PROCESSING_METRICS')
        AND has(extra_keys, 'executionTime')
        AND has([
            'ProcessAggregatedPlanFactDeadlinesExecutor',
            'ProcessPlanFactDeadlinesExecutor'
        ], ifNull(nullIf(extra_values[indexOf(extra_keys, 'executor')], ''), 'unknown'))
        ORDER BY timestamp ASC
    ) AS b
    ON b.period_start = a.period_start
    AND b.executor = a.executor
    WHERE b.start > a.start
    GROUP BY a.start, period_start, a.executor
) as c
GROUP BY period_start, executor
ORDER BY period_start DESC, executor
;
