use marketclickhouse;

SELECT
    date as period_start,
    round(quantileExact(0.99)(toUInt64OrZero(extra_values[indexOf(extra_keys, 'timeSinceSchedulingInMs')])) / 60000) AS over_min,
    ifNull(nullIf(extra_values[indexOf(extra_keys, 'executor')], ''), 'unknown') AS executor
FROM market.logistics_backlog_tskv
WHERE period_start = today() - {delta_in_days}
AND code='PLAN_FACT_PROCESSING_METRICS'
AND environment = 'PRODUCTION'
AND service = 'market_logistics_mqm'
AND executor in ('PlanFactGroupHandlerImpl', 'PlanFactHandlerImpl')
AND has(extra_keys, 'timeSinceSchedulingInMs')
GROUP BY period_start, executor
ORDER BY period_start DESC, executor
;
