USE marketclickhouse;

SELECT
    period_start,
    round(count_500 / count_all * 100, 2) as percent_of_5xx
FROM (
    SELECT
        date as period_start,
        COUNT(*) as count_500
    FROM
        market.nesu_nginx
    PREWHERE
        period_start = today() - {delta_in_days}
        AND environment = 'PRODUCTION'
    WHERE
        (url LIKE '/back-office/business%'
        OR url LIKE '/back-office/partner%')
        AND http_code >= 500 AND http_code <= 599
    GROUP BY
        period_start
) as c500
JOIN (
    SELECT
        date as period_start,
        COUNT(*) as count_all
    FROM
        market.nesu_nginx
    PREWHERE
        period_start = today() - {delta_in_days}
        AND environment = 'PRODUCTION'
    WHERE
        url LIKE '/back-office/business%'
        OR url LIKE '/back-office/partner%'
    GROUP BY
        period_start
) AS c200 ON c500.period_start = c200.period_start
;
