USE marketclickhouse;

SELECT
    period_start,
    round(count_500 / count_all * 100, 2) as percent_of_5xx
FROM (
    SELECT
        date as period_start,
        COUNT(*) as count_500
    FROM
        market.tpl_front_nginx
    PREWHERE
        period_start = today() - {delta_in_days}
    WHERE
        page_id LIKE 'market-partner:html:sorting-center%:get'
        AND http_code >= 500 AND http_code <= 599
    GROUP BY
        period_start
) as c500
JOIN (
    SELECT
        date as period_start,
        COUNT(*) as count_all
    FROM
        market.tpl_front_nginx
    PREWHERE
        period_start = today() - {delta_in_days}
    WHERE
        page_id LIKE 'market-partner:html:sorting-center%:get'
    GROUP BY
        period_start
) AS c200 ON c500.period_start = c200.period_start;
