USE marketclickhouse;

SELECT
    period_start,
    round(count_500 / count_all * 100, 2) as percent_of_5xx
FROM (
    SELECT
        date as period_start,
        COUNT(*) as count_500
    FROM
        market.sc_api_nginx
    WHERE
        period_start = today() - {delta_in_days}
        AND environment = 'PRODUCTION'
        AND page_id in ('PUT_api_orders_accept', 'PUT_api_orders_id')
        AND http_code >= 500 AND http_code <= 599
    GROUP BY
        period_start
) as c500
JOIN (
    SELECT
        date as period_start,
        COUNT(*) as count_all
    FROM
        market.sc_api_nginx
    WHERE
        period_start = today() - {delta_in_days}
        AND environment = 'PRODUCTION'
        AND page_id in ('PUT_api_orders_accept', 'PUT_api_orders_id')
    GROUP BY
        period_start
) AS c200 ON c500.period_start = c200.period_start
ORDER BY period_start DESC
