USE marketclickhouse;

SELECT
    period_start,
    round(SUM(page_count / total_count * resp_95), 2) AS weighted_resp_95
FROM (
    SELECT
        date as period_start,
        count(*) as total_count
    FROM
        market.sc_api_nginx
    WHERE
        period_start = today() - {delta_in_days}
        AND environment = 'PRODUCTION'
        AND page_id in ('PUT_api_orders_accept', 'PUT_api_orders_id')
    GROUP BY
        period_start
) as total
JOIN (
    SELECT
        date as period_start,
        page_id,
        quantile(0.95)(resptime_ms) AS resp_95,
        count(*) as page_count
     FROM
        market.sc_api_nginx
    WHERE
        period_start = today() - {delta_in_days}
        AND environment = 'PRODUCTION'
        AND page_id in ('PUT_api_orders_accept', 'PUT_api_orders_id')
    GROUP BY
        period_start,
        page_id
) as page ON page.period_start = total.period_start
GROUP BY
    period_start
ORDER BY
    period_start DESC;
