USE marketclickhouse;

SELECT
    period_start,
    round(SUM(page_count / total_count * resp_95), 2) AS weighted_resp_95
FROM (
    SELECT
        date as period_start,
        count(*) as total_count
    FROM
        market.tpl_int_nginx
    WHERE
        period_start = today() - {delta_in_days}
        AND environment = 'PRODUCTION'
        AND (page_id in (
                'GET_internal_partner_orders_id_events',
                'GET_internal_partner_orders',
                'GET_internal_partner_orders_orderId',
                'GET_internal_partner_transportTypes_v2',
                'GET_internal_partner_transportTypes',
                'GET_internal_partner_companies_id_flags',
                'GET_internal_partner_users',
                'GET_internal_partner_users_schedules',
                'GET_internal_partner_companies',
                'GET_internal_partner_user-shifts',
                'GET_internal_partner_shifts'
                ) OR page_id like '%internal_partner_filters%'
            )
    GROUP BY
        period_start
) as total
JOIN (
    SELECT
        date as period_start,
        page_id,
        quantile(0.95)(resptime_ms) AS resp_95,
        count(*) as page_count
     FROM
        market.tpl_int_nginx
    WHERE
        period_start = today() - {delta_in_days}
        AND environment = 'PRODUCTION'
        AND (page_id in (
                'GET_internal_partner_orders_id_events',
                'GET_internal_partner_orders',
                'GET_internal_partner_orders_orderId',
                'GET_internal_partner_transportTypes_v2',
                'GET_internal_partner_transportTypes',
                'GET_internal_partner_companies_id_flags',
                'GET_internal_partner_users',
                'GET_internal_partner_users_schedules',
                'GET_internal_partner_companies',
                'GET_internal_partner_user-shifts',
                'GET_internal_partner_shifts'
                ) OR page_id like '%internal_partner_filters%'
            )
    GROUP BY
        period_start,
        page_id
) as page ON page.period_start = total.period_start
GROUP BY
    period_start
ORDER BY
    period_start DESC;
