USE marketclickhouse;

SELECT
    period_start,
    round(count_error / count_all * 100, 2) as percent_of_error
FROM (
    SELECT
        date as period_start,
        countIf(key = 'LOGISTIC_API_RESPONSE_ERROR') as count_error,
        countIf(key in ('LOGISTIC_API_RESPONSE_ERROR', 'LOGISTIC_API_RESPONSE_OK')) as count_all
    FROM
        market.common_kv
    WHERE
        period_start = today() - {delta_in_days}
        AND module = 'tpl-int'
        AND subkey in ('createOrder', 'createIntake', 'putMovement')
    GROUP BY
        period_start
)
;
