USE marketclickhouse;

SELECT
    period_start,
    round(count_500 / count_all * 100, 2) as percent_of_5xx
FROM (
    SELECT
        date as period_start,
        COUNT(*) as count_500
    FROM
        market.tpl_int_nginx
    WHERE
        period_start = today() - {delta_in_days}
        AND environment = 'PRODUCTION'
        AND (page_id in (
                'GET_internal_partner_orders_id_events',
                'GET_internal_partner_orders',
                'GET_internal_partner_orders_orderId',
                'GET_internal_partner_transportTypes_v2',
                'GET_internal_partner_transportTypes',
                'GET_internal_partner_companies_id_flags',
                'GET_internal_partner_users',
                'GET_internal_partner_users_schedules',
                'GET_internal_partner_companies',
                'GET_internal_partner_user-shifts',
                'GET_internal_partner_shifts'
                ) OR page_id like '%internal_partner_filters%'
            )
        AND http_code >= 500 AND http_code <= 599
    GROUP BY
        period_start
) as c500
JOIN (
    SELECT
        date as period_start,
        COUNT(*) as count_all
    FROM
        market.tpl_int_nginx
    WHERE
        period_start = today() - {delta_in_days}
        AND environment = 'PRODUCTION'
        AND (page_id in (
                'GET_internal_partner_orders_id_events',
                'GET_internal_partner_orders',
                'GET_internal_partner_orders_orderId',
                'GET_internal_partner_transportTypes_v2',
                'GET_internal_partner_transportTypes',
                'GET_internal_partner_companies_id_flags',
                'GET_internal_partner_users',
                'GET_internal_partner_users_schedules',
                'GET_internal_partner_companies',
                'GET_internal_partner_user-shifts',
                'GET_internal_partner_shifts'
                ) OR page_id like '%internal_partner_filters%'
            )
    GROUP BY
        period_start
) AS c200 ON c500.period_start = c200.period_start
ORDER BY period_start DESC;
