USE marketclickhouse;

SELECT
    period_start,
    round(SUM(page_count_95 / total_count * resp_95), 2) AS weighted_resp_95_ms
FROM (
    SELECT
        date as period_start,
        count(*) as total_count
    FROM
        market.delivery_tracker_access
    WHERE
        period_start = today() - {delta_in_days}
        AND environment = 'PRODUCTION'
        AND (page_id = 'PUT_orders_status_push')
    GROUP BY
        period_start
) as total
JOIN (
    SELECT
        date as period_start,
        page_id,
        quantile(0.95)(resptime_ms) AS resp_95,
        count(*) as page_count_95
     FROM
        market.delivery_tracker_access
    WHERE
        period_start = today() - {delta_in_days}
        AND environment = 'PRODUCTION'
        AND (page_id = 'PUT_orders_status_push')
    GROUP BY
        period_start,
        page_id
) as page95 ON page95.period_start = total.period_start
GROUP BY
    period_start
ORDER BY
    period_start DESC;
