USE marketclickhouse;

SELECT
    total.period_start,
    round(SUM(p95.count / total.count * p95.percentile), 2) AS weighted_resp_95_s
FROM (
    SELECT
        date as period_start,
        count(*) AS count
    FROM `market`.`market_delivery_tracker_checkpoints` AS c
    WHERE period_start = today() - {delta_in_days}
    AND c.firstNotifySuccess = 1
    AND environment = 'PRODUCTION'
    AND entityType = 'ORDER'
    AND deliveryServiceRole in ('EXTERNAL_PVZ', 'PVZ')
    GROUP BY period_start
) AS total
INNER JOIN (
    SELECT
        date as period_start,
        c95.deliveryServiceId AS service_id,
        count(*) AS count,
        quantileExact(0.95)(toUInt32(c95.lastNotifySuccessTs) - toUInt32(c95.checkpointTs)) AS percentile
    FROM `market`.`market_delivery_tracker_checkpoints` AS c95
    WHERE period_start = today() - {delta_in_days}
    AND c95.firstNotifySuccess = 1
    AND environment = 'PRODUCTION'
    AND entityType = 'ORDER'
    AND deliveryServiceRole in ('EXTERNAL_PVZ', 'PVZ')
    GROUP BY period_start, c95.deliveryServiceId
) AS p95 ON p95.period_start = total.period_start
GROUP BY
    total.period_start
ORDER BY
    total.period_start DESC;
