$hourInMs = 3600000;
$timezone = "Europe/Moscow";
$days = {delta_in_days};
$delta_days = DateTime::MakeDate(DateTime::FromMilliseconds(
    DateTime::ToMilliseconds(CurrentTzTimestamp($timezone)) - ($hourInMs * 24) * $days
));

SELECT
SOME(ff_orders.period_start) as period_start,
SUM(ff_orders.order_count) as number_of_orders,
PERCENTILE(ff_orders.order_count, 0.95) AS orders_95,
MAX_BY(ff_orders.ff_id, ff_orders.order_count) as ff_with_max_orders,
0 as delay_min_95
FROM (
    SELECT DateTime::MakeDate(sub.order_date) as period_start,
    sub.order_date as order_date,
    sub.ff_id,
    count(sub.order_id) as order_count
    FROM (
        SELECT DateTime::MakeDate(DateTime::ParseIso8601(o.`created`)) as order_date,
            orders_with_min_101.min_101_date_time as create_datetime,
            DateTime::FromMilliseconds(DateTime::ToMilliseconds(DateTime::MakeDatetime(DateTime::ParseIso8601(ws.shipment_date_time))) - 3*$hourInMs) as cutoff,
            ws.partner_id as ff_id,
            o.external_id as order_id,
            DateTime::MakeTimestamp(DateTime::ParseIso8601(orders_with_min_101.min_101_date_time)) - DateTime::FromMilliseconds(DateTime::ToMilliseconds(DateTime::MakeDatetime(DateTime::ParseIso8601(ws.shipment_date_time))) - 3*$hourInMs) as delay
        FROM hahn.`home/cdc/prod/market/logistics_lom/orders` as o
        JOIN hahn.`home/cdc/prod/market/logistics_lom/waybill_segment` as ws ON ws.order_id = o.id
        JOIN (
                SELECT o.external_id as barcode, min(wssh.`date`) as min_101_date_time
                FROM hahn.`home/cdc/prod/market/logistics_lom/orders` as o
                JOIN hahn.`home/cdc/prod/market/logistics_lom/waybill_segment` as ws on ws.order_id = o.id
                JOIN hahn.`home/cdc/prod/market/logistics_lom/waybill_segment_status_history` as wssh ON wssh.waybill_segment_id = ws.id
                WHERE ws.segment_type = 'FULFILLMENT' and ws.waybill_segment_index = 0
                and ws.shipment_date_time IS NOT NULL
                and wssh.`tracker_status` = 'SORTING_CENTER_LOADED'
                and DateTime::MakeDate(DateTime::ParseIso8601(o.`created`)) = $delta_days
                GROUP BY o.external_id
            ) as orders_with_min_101 ON orders_with_min_101.barcode = o.external_id
        WHERE DateTime::MakeTimestamp(DateTime::ParseIso8601(orders_with_min_101.min_101_date_time)) > DateTime::FromMilliseconds(DateTime::ToMilliseconds(DateTime::MakeDatetime(DateTime::ParseIso8601(ws.shipment_date_time))) - 3*$hourInMs)
        and ws.segment_type = 'FULFILLMENT' and ws.waybill_segment_index = 0
        and ws.shipment_date_time IS NOT NULL
    ) as sub
    GROUP BY sub.order_date, sub.ff_id
) as ff_orders;
