USE hahn;

$threshold=3;

$hourInMs = 3600000;
$days = {delta_in_days};
$timezone = "Europe/Moscow";
$delta_days = DateTime::MakeDate(DateTime::FromMilliseconds(
    DateTime::ToMilliseconds(CurrentTzTimestamp($timezone)) - ($hourInMs * 24) * $days
));
$source_table = "//home/market/production/tpl/pvz/pickup_point_stat_by_combi";

$interval_report = (
    SELECT
        AddTimezone(DateTime::MakeDate(creation_time), $timezone) as dt,
        creation_time,
        cnt_available,
        cnt_active - cnt_available as cnt_unavailable,
        Math::Round(100.0 * (cnt_active - cnt_available) / cnt_active, -2) as percent_unavailable,
        LAG(cnt_available) OVER w,
        LAG(creation_time) OVER w,
        DateTime::ToMinutes(creation_time - LAG(creation_time) OVER w) as time_delta
    FROM
        $source_table
    WHERE
        subtype = 5
        AND DateTime::MakeDate(creation_time) = $delta_days
    WINDOW w AS(
        PARTITION BY 1
        ORDER BY  creation_time ASC
    )
);

select
    dt as period_start,
    PERCENTILE(percent_unavailable, 0.99) as unavailable_percent_99 ,
    COALESCE(Math::Round(sumIf(time_delta, percent_unavailable > $threshold)/ 60.0, -2), 0)  AS sla_miss_time,
    PERCENTILE(cnt_unavailable , 0.95) as unavail_95
from $interval_report as q
group by dt;

