# -*- coding: utf-8 -*-

import os
import logging
from .helpers import catch
from sandbox.common import fs


class Clickhouse:
    def __init__(self, token, query_path, dry_run=False):
        from yql.api.v1.client import YqlClient

        self._client = YqlClient(token=token)
        self._query_path = query_path
        self._dry_run = dry_run

    @catch()
    def execute_query(self, path, period_start_delta_in_days):
        from yql.client.operation import YqlOperationType

        query_path = "clickhouse/{}".format(path)

        logging.info("Executing query from %s", query_path)

        query = fs.read_file(os.path.join(self._query_path, query_path)).decode("utf-8")
        query = query.replace("{delta_in_days}", str(period_start_delta_in_days))

        logging.info("Executing query %s", query)

        if self._dry_run:
            return []

        request = self._client.query(query, syntax_version=1)
        request.type = YqlOperationType.CLICKHOUSE
        request.run()

        result = request.get_results()

        logging.info("Result %s: %s", query_path, result)

        return result.table.rows
