import logging


def catch(retry=3):
    def decorator(method):
        def wrapper(self, path, period_start_delta_in_days):
            step_count = 0
            while step_count < retry:
                try:
                    return method(self, path, period_start_delta_in_days)
                except Exception:
                    logging.exception("Execute query error")
                    step_count += 1
            if step_count > 0:
                raise
        return wrapper
    return decorator
