import logging
import os

from sandbox.common import fs


class Migrations:

    def __init__(self, host, port, dbname, user, password, migration_files):
        self._url = "postgres://{user}:{password}@{host}:{port}/{dbname}".format(
            host=host,
            port=port,
            dbname=dbname,
            user=user,
            password=password
        )

        self._migrations = migration_files
        self._migrations_path = "migrations"

        self._copy_migrations()

    def _copy_migrations(self):
        os.mkdir(self._migrations_path)

        for filename in self._migrations:
            with open(os.path.join(self._migrations_path, filename), "ab+") as f:
                f.write(fs.read_file(filename))

    def migrate(self):
        from yoyo import read_migrations
        from yoyo import get_backend

        backend = get_backend(self._url)
        migrations = read_migrations(self._migrations_path)

        with backend.lock():
            # Apply any outstanding migrations
            backend.apply_migrations(backend.to_apply(migrations))

        logging.info("Migrated")

    def rollback(self):
        from yoyo import read_migrations
        from yoyo import get_backend

        backend = get_backend(self._url)
        migrations = read_migrations(self._migrations_path)

        with backend.lock():
            # Rollback all migrations
            backend.rollback_migrations(backend.to_rollback(migrations))

        logging.info("Rollback")
