# -*- coding: utf-8 -*-

import math
import datetime
import os
from datetime import date
from sandbox.common import fs

def get_week_interval(start_period_delta_days):
    today = date.today()
    monday = today - datetime.timedelta(days=7 * start_period_delta_days + today.weekday())
    sunday = monday + datetime.timedelta(days=6)
    return monday, sunday


def get_day_interval(start_period_delta_days, shift=1):
    cur_day = date.today() - datetime.timedelta(days=start_period_delta_days - shift)
    day_before = cur_day - datetime.timedelta(days=1)
    return day_before, cur_day


def get_previous_week_interval(start_period_delta_days):
    today = date.today()
    monday = today - datetime.timedelta(days=14 + (7 * (start_period_delta_days - 1)) + today.weekday())
    sunday = monday + datetime.timedelta(days=6)
    return monday, sunday


def get_quarter():
    today = date.today()
    return "Q{}".format(int(math.ceil(today.month / 3)))


def get_subject(start_period_delta_days):
    (start, end) = get_day_interval(start_period_delta_days)
    subject = "Отчет с {start} по {end}"
    return subject.format(start=start, end=end)


def get_message_body(note, streams, stability, start_period_delta_days):
    from jinja2 import Template

    template = Template(fs.read_file(os.path.join("template", "table.html")).decode("utf-8"))

    (current_start, current_end) = get_day_interval(start_period_delta_days)
    (previous_start, previous_end) = get_day_interval(start_period_delta_days, 0)

    return template.render(
        streams=streams,
        stability=stability,
        current_start=current_start.strftime("%d.%m"),
        current_end=current_end.strftime("%d.%m"),
        previous_start=previous_start.strftime("%d.%m"),
        previous_end=previous_end.strftime("%d.%m"),
        quarter=get_quarter(),
        note=note
    )
