from sandbox import sdk2
from sandbox.projects.common import binary_task


class MarketResourceMonitor(binary_task.LastBinaryTaskRelease, sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        abc_secret = sdk2.parameters.YavSecret('Secret with ABC oauth token')
        abc_root = sdk2.parameters.String('Root ABC service name for tagging hosts')
        nanny_secret = sdk2.parameters.YavSecret('Secret with Nanny oauth token')
        yt_secret = sdk2.parameters.YavSecret('Secret with YT oauth token')
        yt_proxy = sdk2.parameters.String('YT proxy')
        yt_path = sdk2.parameters.String('YT output folder')
        yt_keep_count = sdk2.parameters.Integer('Number of versions of output tables to keep', default=30)
        limit = sdk2.parameters.Integer('Number of gencfg services to retrieve (use it for debug)', default=None)
        num_threads = sdk2.parameters.Integer('Number of threads for requesting gencfg', default=2)
        ext_params = binary_task.binary_release_parameters(stable=True)

    def on_execute(self):
        super(MarketResourceMonitor, self).on_execute()
        self._execute()

    def _execute(self):
        from market.tools.resource_monitor.lib import calc
        abc_token = self.Parameters.abc_secret.data()['abc-token']
        abc_root = self.Parameters.abc_root
        nanny_token = self.Parameters.nanny_secret.data()['nanny-token']
        yt_token = self.Parameters.yt_secret.data()['yt-token']
        yt_proxy = self.Parameters.yt_proxy
        yt_path = self.Parameters.yt_path
        yt_keep_count = self.Parameters.yt_keep_count
        limit = self.Parameters.limit
        num_threads = self.Parameters.num_threads
        calc.run_all(abc_root=abc_root,
                     abc_token=abc_token,
                     nanny_token=nanny_token,
                     yt_path=yt_path,
                     yt_proxy=yt_proxy,
                     yt_token=yt_token,
                     keep_count=yt_keep_count,
                     limit=limit,
                     num_threads=num_threads)


class MarketRtcUsage(binary_task.LastBinaryTaskRelease, sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        yt_secret = sdk2.parameters.YavSecret('Secret with YT oauth token')
        yt_proxy = sdk2.parameters.String('YT proxy')
        yt_path = sdk2.parameters.String('YT output folder')
        yt_keep_count = sdk2.parameters.Integer('Number of versions of output tables to keep', default=30)
        ext_params = binary_task.binary_release_parameters(stable=True)

    def on_execute(self):
        super(MarketRtcUsage, self).on_execute()
        self._execute()

    def _execute(self):
        from market.tools.resource_monitor.lib import usage
        yt_token = self.Parameters.yt_secret.data()['yt-token']
        yt_proxy = self.Parameters.yt_proxy
        yt_path = self.Parameters.yt_path
        yt_keep_count = self.Parameters.yt_keep_count
        usage.run_usage(
            yt_path=yt_path,
            yt_proxy=yt_proxy,
            yt_token=yt_token,
            keep_count=yt_keep_count)


class MarketYtResourceMonitor(binary_task.LastBinaryTaskRelease, sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        abc_secret = sdk2.parameters.YavSecret('Secret with ABC oauth token')
        abc_root = sdk2.parameters.String('Root ABC service name')
        st_secret = sdk2.parameters.YavSecret('Secret with Staff API oauth token')
        yt_secret = sdk2.parameters.YavSecret('Secret with YT oauth token')
        yt_proxy = sdk2.parameters.String('YT proxy')
        yt_path = sdk2.parameters.String('YT output folder')
        yt_keep_count = sdk2.parameters.Integer('Number of versions of output tables to keep', default=30)
        ext_params = binary_task.binary_release_parameters(stable=True)

    def on_execute(self):
        super(MarketYtResourceMonitor, self).on_execute()
        self._execute()

    def _execute(self):
        from market.tools.resource_monitor.lib import calc
        abc_token = self.Parameters.abc_secret.data()['abc-token']
        abc_root = self.Parameters.abc_root
        st_token = self.Parameters.st_secret.data()['st-token']
        yt_token = self.Parameters.yt_secret.data()['yt-token']
        yt_proxy = self.Parameters.yt_proxy
        yt_path = self.Parameters.yt_path
        yt_keep_count = self.Parameters.yt_keep_count
        calc.run_yt(user_login='grishakov',
                    abc_root=abc_root,
                    abc_token=abc_token,
                    yt_path=yt_path,
                    yt_proxy=yt_proxy,
                    yt_token=yt_token,
                    st_token=st_token,
                    keep_count=yt_keep_count)


class MarketResourceTotalCostCount(binary_task.LastBinaryTaskRelease, sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        yql_secret = sdk2.parameters.YavSecret('Secret wiht YQL oauth token')
        yt_proxy = sdk2.parameters.String('YT proxy')
        yt_path = sdk2.parameters.String('YT output folder')
        ext_params = binary_task.binary_release_parameters(stable=True)

    def on_execute(self):
        super(MarketResourceTotalCostCount, self).on_execute()
        self._execute()

    def _execute(self):
        from market.tools.resource_monitor.lib import calc
        yql_token = self.Parameters.yql_secret.data()['yql-token']
        yt_proxy = self.Parameters.yt_proxy
        yt_path = self.Parameters.yt_path
        calc.run_summarize(yql_token=yql_token, yt_proxy=yt_proxy, yt_path=yt_path)


class MarketResourceSummary(binary_task.LastBinaryTaskRelease, sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        yql_secret = sdk2.parameters.YavSecret('Secret wiht YQL oauth token')
        yt_proxy = sdk2.parameters.String('YT proxy')
        yt_path = sdk2.parameters.String('YT output folder')
        ext_params = binary_task.binary_release_parameters(stable=True)

    def on_execute(self):
        super(MarketResourceSummary, self).on_execute()
        self._execute()

    def _execute(self):
        from market.tools.resource_monitor.lib import calc
        yql_token = self.Parameters.yql_secret.data()['yql-token']
        yt_proxy = self.Parameters.yt_proxy
        yt_path = self.Parameters.yt_path
        calc.run_summarize_components(yql_token=yql_token, yt_proxy=yt_proxy, yt_path=yt_path)


class MarketYtDynTablesResourcesCounter(binary_task.LastBinaryTaskRelease, sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        st_secret = sdk2.parameters.YavSecret('Secret with Staff api oauth token')
        yt_secret = sdk2.parameters.YavSecret('Secret with YT oauth token')
        yt_proxy = sdk2.parameters.String('YT proxy')
        yt_path = sdk2.parameters.String('YT output folder')
        yt_keep_count = sdk2.parameters.Integer('Number of versions of output tables to keep', default=30)
        ext_params = binary_task.binary_release_parameters(stable=True)

    def on_execute(self):
        super(MarketYtDynTablesResourcesCounter, self).on_execute()
        self._execute()

    def _execute(self):
        from market.tools.resource_monitor.lib import calc
        st_token = self.Parameters.st_secret.data()['st-token']
        yt_token = self.Parameters.yt_secret.data()['yt-token']
        yt_proxy = self.Parameters.yt_proxy
        yt_path = self.Parameters.yt_path
        yt_keep_count = self.Parameters.yt_keep_count
        calc.run_yt_dtables(
            user_login='grishakov',
            yt_proxy=yt_proxy,
            yt_path=yt_path,
            yt_token=yt_token,
            st_token=st_token,
            keep_count=yt_keep_count)


class MarketReportLogYtDiskSpaceMonitor(binary_task.LastBinaryTaskRelease, sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        yt_secret = sdk2.parameters.YavSecret('Secret with YT oauth token')
        solomon_secret = sdk2.parameters.YavSecret('Secret with Solomon oauth token')
        ext_params = binary_task.binary_release_parameters(stable=True)

    def on_execute(self):
        super(MarketReportLogYtDiskSpaceMonitor, self).on_execute()
        self._execute()

    def _execute(self):
        from market.tools.resource_monitor.lib import yt_tables

        yt_token = self.Parameters.yt_secret.data()['yt-token']
        solomon_token = self.Parameters.solomon_secret.data()['solomon-token']

        folders = [
            '//logs/market-feature-log',
            '//logs/market-parallel-report-log',
            '//logs/market-main-report-log',
            '//logs/market-new-shows-log',
            '//logs/market-int-report-log']
        clusters = ['hahn', 'arnold']
        for yt_proxy in clusters:
            for yt_folder in folders:
                yt_tables.push_folder_metrics(
                    yt_token=yt_token,
                    yt_proxy=yt_proxy,
                    path=yt_folder,
                    solomon_token=solomon_token,
                    solomon_project='market-report')
