# coding: utf-8

from sandbox import sdk2
from sandbox.projects.resource_types import marketsre
from sandbox.projects.market.resources.idx import MARKET_OFFERS_ROBOT2_APP, MARKET_REPORT_DIST, MARKET_REPORT_DIST_META, MARKET_REPORT_PUBLISHER_CONF  # noqa

# Groups
market_sre_group = ['MARKETSRE']
market_idx_group = ['MARKET-IDX']
market_mbi_group = ['MARKET-MBI']
market_crm_group = ['MARKET_CRM_DEVELOPMENT']
market_wms_group = ['MARKET-WMS']
market_promo_group = ['MARKET-PROMO']

# Robots
market_teamcity = ['teamcity']  # It's used to release tasks
robot_market_infra = ['robot-market-infra']  # It's used to release tasks
robot_mrk_teamcity = ['robot-mrk-teamcity']  # It's used to release tasks

# People
market_kgb = ['axc', 'ya-spe', 'sambuka', 'nadya73', 'sildtm', 'vladon', 'zaripov-kamil', 'fess7', 'achugunov', 'kolun', 'veminaev', 'olegtitov']
market_ugc = ['yuraaka', 'vladon', 'sildtm', 'elenita', 'sambuka', 'korolyov']
market_mbi = ['berest', 'm-bazhenov']
market_ir_mbo = [
    'mkrasnoperov',
    'alvorontsov',
    'marbok',
    'a-shar',
    'machnev',
    'uchitelev',
    'heylimon',
    'vseryakova'
]
market_report = [
    'fantamp',
    'yuraaka',
    'lognick',
    'zhnick',
    'robot-market-st',
    'popov-ng',
    'omakovski',
    'heap',
    'manushkin',
    'sereja589',
    'ants',
    'dmamylin'
]
market_cs = ['ya-spe', 'd-burkov', 'khaipov']
market_torrent_client = ['yuraaka', 'manushkin', 'lognick', 'zhnick', 'sereja589']
market_pers = [
    'valter',
    'a-danilov',
    'ukchuvrus',
    'maratik',
    'dinyat',
    'korolyov',
    'varvara',
    'gnefedev',
    'stille',
    'semin-serg',
]
market_loyalty = ['artemmz', 'fonar101', 'telerman', 'robot-market-promo']
market_fmcg = ['valter', 'revers', 'a-ylshin', 'topchyalexey', 'galaxy']
market_price_center = ['agavrikov']
market_checkout = ['poluektov', 'timursha', 'dis']
market_front = ['MARKET']
market_front_infra = ['MARKETFRONTTECH']  # Пересекается со списком выше! (спасибо, кэп!)
market_marketdev_business_backoffice = ['imelnikov', 'antipov93', '0x40', 'agavrikov', 'frenki', 'kukabara', 'artemmz']
market_marketdev_business_mining = [
    'vzay',
    'scooter',
    'sikora',
    'ninok',
    'anmalysh',
    'danfertev',
    'dmserebr',
    'commince',
    'york',
    'pochemuto',
    's-ermakov',
    'mkrasnoperov',
    'nkondratyeva',
    'inenakhov',
    'a-shar',
    'masterj',
    'tanlit',
    'jenkl',
    'amaslak',
    'cramen',
    'chervotkin',
    'yuramalinov',
    'gavrilov-mi',
    'mibobkov',
    'k-semeon',
    'alabr',
    'goryunov-se',
    'apluhin'
]
market_ex_content_api = [
    'vedmax',
    'karpenkoms',
    'vivg',
    'tesseract',
    'apershukov',
    'e-golov',
    'vawsome',
    'vdorogin',
    'entarrion',
    'vtarasoff'
]
market_content_api = [
    'dimkarp93',
    'sergei-lipin',
    'aproskriakov',
    'incsall'
]
market_ocrm = [
    'gallyamb',
    'tesseract',
    'anton0xf',
    'yntv',
    'vawsome',
    'vdorogin',
    'dphilippov87',
    'kvloginov',
    'hronos',
]

market_scantobuy = [
    'ashwets',
]

# deprecated, see notice at the top of the file
# Groups
mbi_shops_group_urls = [
    'yandex_monetize_market_marketdev_business_devbus',
    'yandex_infra_tech_testing_mondesk_market_autotst_partners',
    'yandex_monetize_market_marketdev_business_billing_interface',
]
mbi_billing_group_urls = ['yandex_monetize_market_marketdev_business_billing_dev']
mbi_admin_group_urls = ['yandex_monetize_market_marketdev_6570_0401']
mbi_group_urls = mbi_shops_group_urls + mbi_billing_group_urls
market_monetize_group_urls = ['dpt_yandex_monetize_market_marketdev']

market_front_infra_url = ['yandex_monetize_market_management_infra_tech']
market_front_partner_url = ['yandex_monetize_market_marketdev_interface_partint']
market_front_vendor_url = ['yandex_monetize_market_marketdev_interface_spb']
market_front_touch_url = ['yandex_monetize_market_marketdev_interface_mob']
market_front_desktop_url = [
    'yandex_monetize_market_marketdev_interface_personal',
    'yandex_monetize_market_marketdev_interface_7665',
]

market_ir_group_url = 'yandex_monetize_market_marketdev_business_mining_dev'
market_mbo_group_url = 'yandex_monetize_market_marketdev_business_mining'
market_delivery_group_url = 'yandex_monetize_market_marketdev_shipping'
market_stat_group_url = 'yandex_monetize_market_marketdev_business_stat'
market_checkout_group_url = 'yandex_monetize_market_marketdev_business_billing_devmp'
market_infra_group_url = 'yandex_monetize_market_marketdev_admin_infra'
market_monet_dev_group_url = 'yandex_monetize_market_marketdev_5144'


# deprecated, see notice at the top of the file


def build_query_for_group(groups, include_children=True):
    group_ids = []
    group_urls = []

    for group in groups:
        if type(group) == str:
            group_urls.append(group)
        elif type(group) == int:
            group_ids.append(group)

    group_ids_list = '[%s]' % ','.join(str(gid) for gid in group_ids)
    group_urls_list = '[%s]' % ','.join(str(url) for url in (map(lambda url: '"%s"' % url, group_urls)))

    query = '(person.official.is_dismissed == false)'

    if len(group_ids):
        if include_children:
            query = 'and (group.id in ' + group_ids_list + ' or group.ancestors.id in ' + group_ids_list + ')'
        else:
            query = 'and (group.id in ' + group_ids_list + ')'

    if len(group_urls):

        if include_children:
            query += 'and (group.url in ' + group_urls_list + ' or group.ancestors.url in ' + group_urls_list + ')'
        else:
            query += 'and (group.url in ' + group_urls_list + ')'

    return query


class MarketToolsYt(sdk2.Resource):
    ttl = 50
    executable = True
    releasable = True
    auto_backup = True
    releasers = market_report + robot_market_infra


class MarketToolsYtStat(MarketToolsYt):
    """yt_stat binary"""


class MarketToolsYtDiff(MarketToolsYt):
    """yt_diff binary"""


class MarketFrontCommonResource(sdk2.Resource):
    """Common ancestor for all front resources"""

    releasable = True
    releasers = ["MARKET"]


class MarketFrontCommonNodeAppResource(MarketFrontCommonResource):
    """Marker class for NodeJs applications"""


class PORTO_LAYER_MARKET_JDK(sdk2.Resource):
    """A porto layer contains JDK"""

    releasable = True
    releasers = marketsre
    auto_backup = True


class PORTO_LAYER_MARKET_JDK_XENIAL(sdk2.Resource):
    """A porto layer contains JDK for Xenial images"""

    releasable = True
    releasers = marketsre
    auto_backup = True


class PORTO_LAYER_MARKET_MBO_IR_TMS(sdk2.Resource):
    """A porto layer contains libaio1,libaio-dev packages"""

    releasable = True
    auto_backup = True


class PORTO_LAYER_MARKET_MBO_IR_TMS_XENIAL(sdk2.Resource):
    """A porto layer contains libaio1,libaio-dev packages"""

    releasable = True
    auto_backup = True


class PORTO_LAYER_MARKET_NODEJS(sdk2.Resource):
    """A porto layer contains NodeJS"""

    releasable = True
    releasers = marketsre
    auto_backup = True


class PORTO_LAYER_MARKET_NODEJS_XENIAL(sdk2.Resource):
    """A porto layer contains NodeJS"""

    releasable = True
    releasers = marketsre
    auto_backup = True


class PORTO_LAYER_MARKET_PARTNER_ADV_NODEJS(sdk2.Resource):
    """A porto layer contains NodeJS for partner-adv"""

    releasable = True
    auto_backup = True


class PORTO_LAYER_MARKET_SOVETNIK_NODEJS(sdk2.Resource):
    """A porto layer with NodeJS for Sovetnik"""

    releasable = True
    auto_backup = True


class PORTO_LAYER_MARKET_SOVETNIK_NODEJS_XENIAL(sdk2.Resource):
    """A porto layer with NodeJS for Sovetnik"""

    releasable = True
    auto_backup = True


class PORTO_LAYER_MARKET_XSCRIPT(sdk2.Resource):
    """A market porto layer with XScript"""

    releasable = True
    auto_backup = True


class PORTO_LAYER_MARKET_BASE_LUCID(sdk2.Resource):
    """A market base porto layer for precise"""

    releasable = True
    releasers = marketsre + market_front
    auto_backup = True


class PORTO_LAYER_MARKET_BASE_PRECISE(sdk2.Resource):
    """A market base porto layer for precise"""

    releasable = True
    releasers = marketsre
    auto_backup = True


class PORTO_LAYER_MARKET_BASE_TRUSTY(sdk2.Resource):
    """A market base porto layer for trusty"""

    releasable = True
    releasers = marketsre
    auto_backup = True


class PORTO_LAYER_MARKET_BASE_XENIAL(sdk2.Resource):
    """A market base porto layer for xenail"""

    releasable = True
    releasers = marketsre
    auto_backup = True


class PORTO_LAYER_MARKET_NODEJS_10_XENIAL(sdk2.Resource):
    """A market porto layer for xenail with NODEJS v10"""

    releasable = True
    releasers = marketsre
    auto_backup = True


class PORTO_LAYER_MARKET_PYTHON3(sdk2.Resource):
    """A market porto layer with Python 3"""

    releasable = True
    auto_backup = True


class PORTO_LAYER_MARKET_SCANTOBUY(sdk2.Resource):
    """A market porto layer for scantobuy"""

    releasable = True
    releasers = marketsre + market_scantobuy
    auto_backup = True


class MARKET_COMMON_CONFIG(sdk2.Resource):
    """Market Common Config"""

    releasable = True
    releasers = marketsre + market_front_infra + robot_market_infra
    auto_backup = True


class MARKET_REPORT_COMMON_CONFIG(sdk2.Resource):
    """Market Common Config"""

    releasable = True
    releasers = marketsre + market_front_infra + robot_market_infra
    auto_backup = True


class MARKET_MBO_CATEGORY_NGINX_CONFIG(sdk2.Resource):
    """Market nginx config for MBO Category"""

    releasable = True
    releasers = marketsre + market_front_infra + robot_market_infra


class MARKET_PERS_INVITE_APP(sdk2.Resource):
    """Pers invite application"""

    releasable = True
    releasers = market_pers + robot_market_infra


class MARKET_SOVETNIK_REDIR_CONFIG(sdk2.Resource):
    """Market Sovetnik Redirection service configs"""

    releasable = True


class MARKET_SOVETNIK_BACKEND_CONFIG(sdk2.Resource):
    """Market Sovetnik backend configs"""

    releasable = True


class MARKET_PRICELABS_API_CONFIG(sdk2.Resource):
    """Market PriceLabs API service configs"""

    releasable = True


class MARKET_PRICELABS_FRONT_CONFIG(sdk2.Resource):
    """Market PriceLabs Front service configs"""

    releasable = True


class MARKET_TEST_APP_BIN(sdk2.Resource):
    """A test java application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_UGCDAEMON_BIN(sdk2.Resource):
    """Market UGC daemon"""

    releasable = True
    releasers = market_ugc + marketsre


class MARKET_LITE(sdk2.Resource):
    """Market LITE package"""

    releasable = True
    releasers = market_ugc + marketsre + market_mbi + market_report + market_front


class MARKET_UGCDAEMON(sdk2.Resource):
    """Market UGC daemon"""

    releasable = True
    releasers = market_ugc + marketsre


class MARKET_PINGER(sdk2.Resource):
    """Market pinger daemon"""

    releasable = True
    releasers = market_report + marketsre


class MARKET_KOMBAT(sdk2.Resource):
    """Market Kombat service"""

    releasable = True
    releasers = market_report + marketsre + robot_market_infra


class MARKET_KOMBAT_CLI(sdk2.Resource):
    """CLI tool for Market Kombat Service"""

    releasable = True
    releasers = market_report + marketsre + robot_market_infra


class MARKET_TORRENT_CLIENT(sdk2.Resource):
    """Market torrent client"""

    ttl = 30
    releasable = True
    releasers = market_torrent_client + marketsre + robot_market_infra


class MARKET_REPORT_MARKET(sdk2.Resource):
    """Market report configs for market search"""

    releasable = True
    releasers = marketsre + market_report


class MARKET_REPORT_NGINX(sdk2.Resource):
    """Market report configs for nginx"""

    releasable = True
    releasers = marketsre + market_report + robot_market_infra


class MARKET_REPORT_MACHETE(sdk2.Resource):
    """UI for market pinger, pinger v2"""

    releasable = True
    releasers = marketsre + market_report + robot_market_infra


class MARKET_REPORT_PUSH_CLIENT(sdk2.Resource):
    """Market report configs for push-client"""

    releasable = True
    releasers = marketsre + market_report + robot_market_infra


class MARKET_REPORT_ARIA(sdk2.Resource):
    """Market report configs for aria"""

    releasable = True
    releasers = marketsre + market_report + robot_market_infra


class MARKET_REPORT_SNIPPET_MARKET(sdk2.Resource):
    """Market report configs for market snippet search"""

    releasable = True
    releasers = marketsre + market_report


class MARKET_REPORT(sdk2.Resource):
    """Market report binaries and control script"""

    releasable = True
    releasers = marketsre + market_report + robot_market_infra


class MARKET_META_REPORT(sdk2.Resource):
    """Market meta report binaries and control script"""

    releasable = True
    releasers = marketsre + market_report + robot_market_infra


class MARKET_SNIPPET_REPORT(sdk2.Resource):
    """Market snippet report binaries and control script"""

    releasable = True
    releasers = marketsre + market_report


class MARKET_REPORT_CTL(sdk2.Resource):
    """Market report control script"""

    releasable = True
    releasers = marketsre + market_report


class MARKET_REPORT_DSSM(sdk2.Resource):
    """Market report dssm formulas"""

    releasable = True
    releasers = marketsre + market_report


class MARKET_REPORT_GRAPHITE_CLIENT(sdk2.Resource):
    """Market report host metrics sender"""

    releasable = True
    releasers = marketsre + market_report + robot_market_infra


class MARKET_REPORT_HOST_METRIC_LOGGER(sdk2.Resource):
    """Host performance metric collector for Market Report"""

    releasable = True
    releasers = marketsre + market_report + robot_market_infra


class MARKET_REPORT_UNIFIED_AGENT(sdk2.Resource):
    """Unified Agent for Market Report"""

    releasable = True
    releasers = marketsre + market_report + robot_market_infra


class MARKET_REPORT_SOLOMON_AGENT(sdk2.Resource):
    """Solomon Agent for Market Report"""

    releasable = True
    releasers = marketsre + market_report + robot_market_infra


class MARKET_REPORT_LITE_DEPENDS(sdk2.Resource):
    """Market report lite test depends (excluding report)"""


class MARKET_REPORT_ZEUS(sdk2.Resource):
    """Market report RTC package installer"""

    releasable = True
    releasers = marketsre + market_report + robot_market_infra


class MARKET_REPORT_BASE_SEARCH_FRESH(sdk2.Resource):
    """Market report fresh base search"""

    releasable = True
    releasers = marketsre + market_report + robot_market_infra


class MARKET_REPORT_DEVTOOLS(sdk2.Resource):
    """Market report development tools"""

    releasable = True
    releasers = marketsre + market_report + robot_market_infra


class MARKET_REPORT_PERF(sdk2.Resource):
    """Perf executable"""

    executable = True


class MARKET_REPORT_JUGGLER_BUNDLE(sdk2.Resource):
    """Market report checks for Juggler"""

    releasable = True
    releasers = marketsre + market_report + robot_market_infra


class MARKET_REPORT_LOGROTATE(sdk2.Resource):
    """Market report logrotate configs"""

    releasable = True
    releasers = marketsre + market_report + robot_market_infra


class MARKET_REPORT_SOLOMON_AGENT_CONF(sdk2.Resource):
    """Market Report Solomon Agent configuration"""

    releasable = True
    releasers = marketsre + market_report + robot_market_infra


class MARKET_SOLOMON_UNISTAT_NGINX_CONF(sdk2.Resource):
    """Market Solomon Agent unistat nginx configuration"""

    releasable = True
    releasers = marketsre + market_report + robot_market_infra


class MARKET_BACKCTLD(sdk2.Resource):
    """Market backctld"""

    ttl = 30
    releasable = True
    releasers = marketsre + market_report + robot_market_infra


class MARKET_REPORT_SHAPI(sdk2.Resource):
    """Market report SHAPI package installer"""

    releasable = True
    releasers = marketsre + market_report + robot_market_infra


class MARKET_REPORT_AMMO_API(sdk2.Resource):
    """Market report AMMO-APPI package installer"""

    releasable = True
    releasers = marketsre + market_report + robot_market_infra


class MARKET_MBI_PARTNER_APP(sdk2.Resource):
    """Market MBI Partner application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBI_SOLOMON_AGENT_CONF(sdk2.Resource):
    """Market MBI Solomon Agent configuration"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBI_SOLOMON_UNISTAT_CONF(sdk2.Resource):
    """Market MBI Solomon Unistat configuration"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_PARTNER_NOTIFICATION_CONFIG(sdk2.Resource):
    """Market Partner Notification Nginx configuration"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_ABO_SOLOMON_AGENT_CONF(sdk2.Resource):
    """Market ABO Solomon Agent configuration"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_ABO_SOLOMON_UNISTAT_CONF(sdk2.Resource):
    """Market ABO Solomon Unistat configuration"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_ADV_SHOP_SOLOMON_AGENT_CONF(sdk2.Resource):
    """Market ADV Solomon Agent configuration"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBI_PARTNER_CONFIG(sdk2.Resource):
    """Market MBI Partner configuration"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_AUTOORDER_CONFIG(sdk2.Resource):
    """Market Autoorder configuration"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBI_PARTNER_MEMCACHED_CONFIG(sdk2.Resource):
    """Market MBI Partner's memcached configuration"""

    releasable = True
    releasers = market_mbi + marketsre + robot_market_infra


class MARKET_BILLING_ADMIN_FRONT_APP(MarketFrontCommonNodeAppResource):
    """Market Billing Admin Frontend"""


class MARKET_BILLING_ADMIN_FRONT_CONFIG(MarketFrontCommonResource):
    """Market Billing Admin Frontend config"""


class MARKET_PARTNER_CMS_FRONT_NODEJS_APP(MarketFrontCommonNodeAppResource):
    """Market Partner CMS Editor Microservice Frontend NodeJS"""


class MARKET_PARTNER_CMS_FRONT_NODEJS_CONFIG(MarketFrontCommonResource):
    """Market Partner CMS Editor Microservice Frontend NodeJS config"""


class MARKET_PARTNER_FRONT_NODEJS_APP(MarketFrontCommonNodeAppResource):
    """Market Partner Frontend NodeJS"""


class MARKET_PARTNER_FRONT_NODEJS_CONFIG(MarketFrontCommonResource):
    """Market Partner Frontend NodeJS config"""


class MARKET_PARTNER_FRONT_ADV_APP(MarketFrontCommonResource):
    """Market Partner Frontend ADV"""


class MARKET_PARTNER_FRONT_ADV_CONFIG(MarketFrontCommonResource):
    """Market Partner Frontend ADV config"""


class MARKET_PARTNER_FRONT_XSCRIPT_APP(MarketFrontCommonResource):
    """Market Partner Frontend XScript"""


class MARKET_PARTNER_FRONT_XSCRIPT_CONFIG(MarketFrontCommonResource):
    """Market Partner Frontend XScript config"""


class MARKET_VENDORS_FRONT_APP(MarketFrontCommonNodeAppResource):
    """Market Vendors Frontend NodeJS"""


class MARKET_VENDORS_FRONT_CONFIG(MarketFrontCommonResource):
    """Market Vendors Frontend NodeJS config"""


class MARKET_ANALYTICS_FRONT_APP(MarketFrontCommonNodeAppResource):
    """Market Analytics Frontend NodeJS"""


class MARKET_ANALYTICS_FRONT_CONFIG(MarketFrontCommonResource):
    """Market Analytics Frontend NodeJS config"""


class MARKET_FRONT_LOG_CLEANER(MarketFrontCommonNodeAppResource):
    """Market Infra Log Cleaner"""


class MARKET_FRONT_TEMPLATE_EMPTY_APP(MarketFrontCommonNodeAppResource):
    """Market NodeJS empty app"""


class MARKET_FRONT_TEMPLATE_EMPTY_TEMPLATE(MarketFrontCommonNodeAppResource):
    """Market NodeJS empty app template"""


class MARKET_FRONT_TEMPLATE_STOUT_APIARY_DESKTOP_CONFIG(MarketFrontCommonNodeAppResource):
    """Market NodeJS tamplate stout apiary desktop config"""


class MARKET_FRONT_TEMPLATE_STOUT_APIARY_APP(MarketFrontCommonNodeAppResource):
    """Market NodeJS template stout apiary app"""


class MARKET_DESKTOP_FRONT(MarketFrontCommonNodeAppResource):
    """Market Desktop Frontend NodeJS"""


class MARKET_FULFILLMENT_YARD_FRONT(MarketFrontCommonNodeAppResource):
    """Market Fulfillment Yard Frontend NodeJS"""


class MARKET_FRONT_BUILD_BASE(MarketFrontCommonNodeAppResource):
    """Market Frontend NodeJS Base"""

    version = sdk2.Attributes.String("Static version", required=True)


class FRONT_BUILD_BASE(MarketFrontCommonNodeAppResource):
    """Market Frontend NodeJS Base"""

    version = sdk2.Attributes.String("Static version", required=True)


class MARKET_FRONT_BUILD_TAR(MarketFrontCommonNodeAppResource):
    """Market Frontend NodeJS Base"""

    version = sdk2.Attributes.String("Static version", required=True)


class MARKET_BLUEDESKTOP_FRONT(MarketFrontCommonNodeAppResource):
    """Market BlueDesktop Frontend NodeJS"""


class MARKET_FRONT_API(MarketFrontCommonNodeAppResource):
    """Front API NodeJS"""


class MARKET_REDDESKTOP_FRONT(MarketFrontCommonNodeAppResource):
    """Market Red Desktop Frontend NodeJS"""

    releasers = ["MARKETREDDEV"]


class MARKET_TOUCH_FRONT(MarketFrontCommonNodeAppResource):
    """Market Touch Frontend NodeJS"""


class MARKET_TOUCH_FRONT_API(MarketFrontCommonNodeAppResource):
    """Market Touch Frontend API NodeJS"""


class MARKET_BLUETOUCH_FRONT(MarketFrontCommonNodeAppResource):
    """Market BlueTouch Frontend NodeJS"""


class MARKET_BLACK_DESKTOP_FRONT(MarketFrontCommonNodeAppResource):
    """Market Black Desktop Frontend NodeJS"""


class MARKET_MF_CORE_FRONT(MarketFrontCommonNodeAppResource):
    """Market Core Microfrontend Frontend NodeJS"""


class MARKET_TOUCH_HYBRID_FRONT(MarketFrontCommonNodeAppResource):
    """Market Touch Hybrid Frontend NodeJS"""


class MARKET_AFFILIATE_FRONT(MarketFrontCommonNodeAppResource):
    """Market Affiliate NodeJS"""


class MARKET_AFFILIATE_FRONT_CONFIG(MarketFrontCommonResource):
    """Market Affiliate Frontend NodeJS config"""


class MARKET_B2B_FRONT_API(MarketFrontCommonNodeAppResource):
    """Market B2B FAPI NodeJS"""


class MARKET_B2B_FRONT_API_CONFIG(MarketFrontCommonResource):
    """Market B2B FAPI NodeJS config"""


class MARKET_TPL_FRONT_APP(MarketFrontCommonNodeAppResource):
    """Market TPL Front NodeJS"""


class MARKET_TPL_FRONT_APP_CONFIG(MarketFrontCommonResource):
    """Market TPL Front NodeJS config"""


class MARKET_EXPORT_STATIC_FRONT(sdk2.Resource):
    """Market static files to export"""


class MARKET_NOTA_CLAIM_CONF(sdk2.Resource):
    """Market nota claim config """

    releasable = True
    releasers = marketsre + market_front + robot_market_infra


class MARKET_FRONT_STATIC_PAGES_CONFIG(sdk2.Resource):
    """Market Front static pages config"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_NOTA_CLAIM_STATIC(sdk2.Resource):
    """Market nota claim static files """

    releasable = True
    releasers = marketsre + market_front + robot_market_infra


class MARKET_CS_DASHBOARD_DEPLOY(sdk2.Resource):
    """Market cs-dashboard resource"""

    releasable = True
    releasers = marketsre


class MARKET_CMS_SRE(sdk2.Resource):
    """Market CMS for Wall-E. To be renamed to MCM"""

    releasable = True
    releasers = marketsre + robot_market_infra


class MARKET_SRE_MCM_SRE_STATIC(sdk2.Resource):
    """Static files for Market CMS for Wall-E"""

    releasable = True
    releasers = marketsre + robot_market_infra


class MARKET_TARANTINO_CONFIG(sdk2.Resource):
    """Market KGB Tarantino config"""

    releasable = True
    releasers = marketsre + market_kgb


class MARKET_TARANTINO_REDIS_CONFIG(sdk2.Resource):
    """Market KGB Tarantino Redis config"""

    releasable = True
    releasers = marketsre + market_kgb


class MARKET_TARANTINO_CACHEPINGER(sdk2.Resource):
    """Market KGB Tarantino cachepinger resource"""

    releasable = True
    releasers = marketsre + market_kgb + robot_market_infra


class MARKET_TEMPLATOR_REDIS_CONFIG(sdk2.Resource):
    """Market KGB TEMPLATOR Redis config"""

    releasable = True
    releasers = marketsre + market_kgb


class MARKET_TEMPLATOR_CONFIG(sdk2.Resource):
    """Market KGB TEMPLATOR config"""

    releasable = True
    releasers = marketsre + market_kgb


class MARKET_TEMPLATOR_BIN(sdk2.Resource):
    """Market KGB Templator binary"""

    releasable = True
    executable = True
    any_arch = False
    auto_backup = True
    arcadia_build_path = 'market/tarantino/templator-server'
    releasers = marketsre + market_kgb


class MARKET_TARANTINO(sdk2.Resource):
    """Market KGB Tarantino config+bin"""

    releasable = True
    releasers = marketsre + market_kgb + robot_market_infra


class MARKET_CONTENT_STORAGE(sdk2.Resource):
    """Market MBO Content-Storage bin"""

    releasable = True
    releasers = marketsre + market_cs + robot_market_infra


class MARKET_TEMPLATOR(sdk2.Resource):
    """Market KGB Templator bin"""

    releasable = True
    releasers = marketsre + market_kgb + robot_market_infra


class MARKET_TEMPLATOR_CONFIG_FAST(sdk2.Resource):
    """Market KGB Templator config"""

    releasable = True
    releasers = marketsre + market_kgb + robot_market_infra


class MARKET_GURUASSISTANT_CONFIG(sdk2.Resource):
    """Market KGB Guruassistant config"""

    releasable = True
    releasers = marketsre + market_kgb


class MARKET_DATA_OTHER(sdk2.resource.AbstractResource):
    """
        Абстрактный ресурс data-getter
    """

    releasable = True
    any_arch = False
    auto_backup = True
    executable = False
    releasers = marketsre + ['robot-data-pusher']


class MARKET_CHECKOUT_SHOPADMIN_STUB_APP(sdk2.Resource):
    """Market Checkout shopadmin-stub application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_CHECKOUT_SHOPADMIN_STUB_APP_CONFIG(sdk2.Resource):
    """Market Checkout shopadmin-stub application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_DATA_JAVA_DEEP_DIVE(MARKET_DATA_OTHER):
    """
        Ресурс data-getter для java deep dive
    """


class MARKET_DATA_CHECKOUTER(MARKET_DATA_OTHER):
    """
        Ресурс data-getter для checkouter
    """


class MARKET_TARANTINO_DATA_GETTER(MARKET_DATA_OTHER):
    """
        Tarantino's resource contains data
    """


class MARKET_DATA_CLASSIFIER(MARKET_DATA_OTHER):
    """
        Classifier's data
    """


class MARKET_DATA_CLASSIFIER_TRAINER(MARKET_DATA_OTHER):
    """
        Classifier trainer data
    """


class MARKET_DATA_BARCODES_CLUSTERIZER(MARKET_DATA_OTHER):
    """
        Barcodes clusterizer data
    """


class MARKET_DATA_CLUSTERIZER(MARKET_DATA_OTHER):
    """
        Clusterizer's data
    """


class MARKET_DATA_FEEDPARSER(MARKET_DATA_OTHER):
    """
        Ресурс data-getter для feedparser
    """


class MARKET_DATA_PAYMENT(MARKET_DATA_OTHER):
    """
        deprecated
    """


class MARKET_DATA_MBI_PARTNER(MARKET_DATA_OTHER):
    """
        Ресурс data-getter для mbi-partner
    """


class MARKET_DATA_SHOPADMIN(MARKET_DATA_OTHER):
    """
        Ресурс data-getter для shopadmin-stub
    """


class MARKET_DATA_SHOPADMIN_CONFIG(MARKET_DATA_OTHER):
    """
        Конфиги для shopadmin-stub
    """

    releasable = True
    releasers = market_checkout + marketsre + market_teamcity + robot_market_infra


class MARKET_DATA_CHECKOUT_LOAD_CONFIG(MARKET_DATA_OTHER):
    """
        Конфиги и утилиты для load-среды чекаутера
    """
    releasable = True
    releasers = market_checkout + marketsre + market_teamcity + robot_market_infra


class MARKET_DATA_CONTENT_API(MARKET_DATA_OTHER):
    """
        Ресурс data-getter для yandex-market-content-api
    """


class MARKET_DATA_CLUTCHER(MARKET_DATA_OTHER):
    """
        Ресурс data-getter для yandex-market-clutcher
    """


class MARKET_DATA_CLUTCHER2(MARKET_DATA_OTHER):
    """
        Ускоренный ресурс data-getter для yandex-market-clutcher
    """
    ttl = 14
    releasers = MARKET_DATA_OTHER.releasers + market_marketdev_business_mining + ['robot-mrk-clchr-test', 'robot-mrk-clchr-prod']


class MARKET_DATA_CLUTCHER2_LAST_SESSION_ID(MARKET_DATA_OTHER):
    """
        Ресурс, содержащий dump_session_id последней сваренной выгрузки клатчера
    """
    ttl = 14
    releasers = MARKET_DATA_CLUTCHER2.releasers


class MARKET_DATA_MATCHER(MARKET_DATA_OTHER):
    """
        Ресурс data-getter для yandex-market-matcher
    """


class MARKET_DATA_MATCHER2(MARKET_DATA_OTHER):
    """
        Ускоренный ресурс data-getter для yandex-market-matcher
    """
    ttl = 14
    releasers = MARKET_DATA_OTHER.releasers + market_marketdev_business_mining + ['robot-mrk-mtchr-test', 'robot-mrk-mtchr-prod']


class MARKET_DATA_MATCHER2_LAST_SESSION_ID(MARKET_DATA_OTHER):
    """
        Ресурс, содержащий dump_session_id последней сваренной выгрузки матчера
    """
    ttl = 14
    releasers = MARKET_DATA_MATCHER2.releasers


class MARKET_DATA_SKUTCHER(MARKET_DATA_OTHER):
    """
        Ускоренный ресурс data-getter для yandex-market-skutcher
    """
    ttl = 14
    releasers = MARKET_DATA_MATCHER2.releasers


class MARKET_DATA_SKUTCHER_LAST_SESSION_ID(MARKET_DATA_OTHER):
    """
        Ресурс, содержащий dump_session_id последней сваренной выгрузки скутчера
    """
    ttl = 14
    releasers = MARKET_DATA_MATCHER2.releasers


class MARKET_DATA_BOOKS_GENERATOR(MARKET_DATA_OTHER):
    """
        Ресурс data-getter для books_generator
    """


class MARKET_DATA_DEEP_MATCHER(MARKET_DATA_OTHER):
    """
        Ресурс deep_matcher для yandex-market-matcher
    """

    releasers = marketsre + market_ir_mbo + ['robot-mrk-ir-sandbox']


class MARKET_DATA_BLACKLIST_FOR_FORMALIZER(MARKET_DATA_OTHER):
    """
        Ресурс blacklist_for_formalizer для yandex-market-formalizer
    """

    releasers = marketsre + market_ir_mbo + ['robot-mkr-ir-sandbox', 'eparinov', 'robot-market-search']


class MARKET_DATA_ALIASES_FROM_REPORT_FOR_FORMALIZER(MARKET_DATA_OTHER):
    """
        Ресурс aliases_report для yandex-market-formalizer
    """

    releasers = marketsre + market_ir_mbo + ['robot-mkr-ir-sandbox', 'eparinov', 'robot-market-search']


class MARKET_DATA_SMART_MATCHER(MARKET_DATA_OTHER):
    """
        Ресурс smart_matcher для yandex-market-matcher
    """

    releasers = marketsre + market_ir_mbo + ['robot-mrk-ir-sandbox']


class MARKET_DATA_SMART_MATCHER_SNAPSHOT(MARKET_DATA_OTHER):
    """
        Ресурс smartmacher snapshot для yandex-market-smartmatcher
    """

    releasers = marketsre + market_ir_mbo + ['robot-mrk-ir-sandbox']


class MARKET_DATA_BERT_SNAPSHOT(MARKET_DATA_OTHER):
    """
        Ресурс bert snapshot для yandex-market-bert-service
    """

    releasers = marketsre + market_ir_mbo + ['robot-mrk-ir-sandbox']


class MARKET_IR_SMART_MATCHER_SNAPSHOT_CREATOR_JAR(sdk2.Resource):
    """
       Jar smartmather snapshot-creator
    """

    releasable = True
    releasers = ["MARKET"]


class MARKET_DATA_TRASHER(MARKET_DATA_OTHER):
    """
        Ресурс trasher для yandex-market-matcher
    """

    releasers = marketsre + market_ir_mbo + ['robot-mrk-ir-sandbox']


class MARKET_DATA_ULTRA_CONTROLLER(MARKET_DATA_OTHER):
    """
        Ресурс data-getter для yandex-ultracontroller
    """


class MARKET_DATA_TITLE_MAKER(MARKET_DATA_OTHER):
    """
        Ресурс data-getter для yandex-market-title-maker
    """


class MARKET_DATA_TITLE_MAKER_TRAINER(MARKET_DATA_OTHER):
    """
        Ресурс data-getter для yandex-market-title-maker-trainer
    """


class MARKET_DATA_MBO_SKUBD(MARKET_DATA_OTHER):
    """
        Ресурс data-getter для yandex-mbo-skubd
    """


class MARKET_DATA_MBO_CMS_GWT(MARKET_DATA_OTHER):
    """
        Ресурс data-getter для yandex-mbo-cms-gwt
    """


class MARKET_DATA_MBO_CMS_GWT_RUDANOV(MARKET_DATA_OTHER):
    """
        Ресурс data-getter для yandex-mbo-cms-gwt
    """


class MARKET_DATA_MBO_CMS_TMS(MARKET_DATA_OTHER):
    """
        Ресурс data-getter для yandex-mbo-cms-tms
    """


class MARKET_DATA_MBO_CMS_API(MARKET_DATA_OTHER):
    """
        Ресурс data-getter для yandex-mbo-cms-api
    """


class MARKET_DATA_MBO_CMS_EDITOR_API(MARKET_DATA_OTHER):
    """
        Ресурс data-getter для yandex-mbo-cms-editor-api
    """


class MARKET_DATA_MBO_CLASSIFIER(MARKET_DATA_OTHER):
    """
        Ресурс data-getter для yandex-mbo-classifier
    """


class MARKET_DATA_MBO_MDM(MARKET_DATA_OTHER):
    """
        Ресурс data-getter для yandex-mbo-mdm
    """


class MARKET_DATA_FORMALIZER(MARKET_DATA_OTHER):
    """
        Ресурс data-getter для yandex-market-formalizer
    """


class MARKET_DATA_FORMALIZER_REPORT(MARKET_DATA_OTHER):
    """
        Ресурс для формализаторов с категориями для репорта
    """


class MARKET_DATA_MARKET_BANNER(MARKET_DATA_OTHER):
    """
        data-getter resource  for market-banner service
    """


class MARKET_DATA_HYPER_CAT_ID(MARKET_DATA_OTHER):
    """
        Ресурс data-getter для hyper-cat-id
    """


class MARKET_DATA_CATALOGER_NAVIGATION(MARKET_DATA_OTHER):
    """
        Ресурс data-getter для cataloger-navigation
    """


class MARKET_DATA_FULFILLMENT_WORKFLOW_API(MARKET_DATA_OTHER):
    """
        Ресурс data-getter для yandex-market-fulfillment-workflow-api
    """


class MARKET_DATA_DICTIONARIES_YT(MARKET_DATA_OTHER):
    """
        Ресурс data-getter для yandex-market-dictionaries-yt
    """


class MARKET_DATA_SITEMAP(MARKET_DATA_OTHER):
    """
        Ресурс data-getter для market-front-sitemap
    """


class MARKET_DATA_CMS_RSS(MARKET_DATA_OTHER):
    """
        Ресурс data-getter для market-cms-rss
    """


class MARKET_DATA_CMS_EXPORTER(MARKET_DATA_OTHER):
    """
        Ресурс data-getter для market-cms-exporter
    """


class MARKET_DATA_PRICELABS_TMS(MARKET_DATA_OTHER):
    """
        Ресурс data-getter для market-pricelabs-tms
    """


class MARKET_DATA_MBI_API(MARKET_DATA_OTHER):
    """
        Ресурс data-getter для market-mbi-api
    """


class MARKET_DATA_ABO_TMS(MARKET_DATA_OTHER):
    """
        Ресурс data-getter для market-abo-tms
    """

    releasers = ['MARKET-ABO'] + marketsre + market_teamcity + robot_market_infra


class MARKET_DATA_PRICECHART_INFO(MARKET_DATA_OTHER):
    """
        Ресурс data-getter для market-pricechart-info
    """


class MARKET_DATA_MARKETSTAT(MARKET_DATA_OTHER):
    """
        Ресурс data-getter для marketstat
    """


class MARKET_DATA_MARKETSTAT_TESTING(MARKET_DATA_OTHER):
    """
        Ресурс data-getter для marketstat testing
    """


class MARKET_DATA_UTILS(MARKET_DATA_OTHER):
    """
        Ресурс data-getter для market-utils
    """


class MARKET_DATA_SERVICES_FOR_GOODS(MARKET_DATA_OTHER):
    """
        Ресурс data-getter для serivces-for-goods
    """


class MARKET_DATA_PERS_TMS(MARKET_DATA_OTHER):
    """
        Р РµСЃСѓСЂСЃ data-getter РґР»СЏ pers-tms
    """


class MARKET_DATA_IR_UI(MARKET_DATA_OTHER):
    """
        Ресурс data-getter для  ir-ui
    """


class MARKET_CLUTCHER_APP(sdk2.Resource):
    """Market Clutcher application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_CLUTCHER_CONFIG(sdk2.Resource):
    """Market Clutcher configuration"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MATCHER_APP(sdk2.Resource):
    """Market Matcher application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MATCHER_CONFIG(sdk2.Resource):
    """Market Matcher configuration"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MATCHER_DATAGETTER(sdk2.Resource):
    """Market Matcher data-getter executable"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_ULTRA_CONTROLLER_APP(sdk2.Resource):
    """Market ULTRA_CONTROLLER application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_ULTRA_CONTROLLER_CONFIG(sdk2.Resource):
    """Market ULTRA_CONTROLLER configuration"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_TITLE_MAKER_APP(sdk2.Resource):
    """Market TITLE_MAKER application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_TITLE_MAKER_CONFIG(sdk2.Resource):
    """Market TITLE_MAKER configuration"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_TITLE_MAKER_TRAINER_APP(sdk2.Resource):
    """Market TITLE_MAKER_TRAINER application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_AUTOGENERATION_API_APP(sdk2.Resource):
    """Market AUTOGENERATION_API application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_GUTGIN_TMS_APP(sdk2.Resource):
    """Market GUTGIN_TMS application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_ROBOT_TMS_APP(sdk2.Resource):
    """Market ROBOT_TMS application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBO_SKUBD_APP(sdk2.Resource):
    """Market Mbo SKUBD application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBO_SKUBD_CONFIG(sdk2.Resource):
    """Market Mbo SKUBD configuration"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBO_CMS_GWT_RUDANOV_APP(sdk2.Resource):
    """Market MBO CMS GWT application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBO_CMS_GWT_RUDANOV_CONFIG(sdk2.Resource):
    """Market MBO CMS GWT configuration"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBO_CMS_GWT_APP(sdk2.Resource):
    """Market MBO CMS GWT application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBO_CMS_GWT_CONFIG(sdk2.Resource):
    """Market MBO CMS GWT configuration"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBO_CMS_TMS_APP(sdk2.Resource):
    """Market MBO CMS TMS application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBO_CMS_TMS_CONFIG(sdk2.Resource):
    """Market MBO CMS TMS configuration"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBO_CMS_API_APP(sdk2.Resource):
    """Market MBO CMS API application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBO_CMS_API_CONFIG(sdk2.Resource):
    """Market MBO CMS API configuration"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBO_CMS_EDITOR_API_APP(sdk2.Resource):
    """Market MBO CMS EDITOR API application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBO_CMS_EDITOR_API_CONFIG(sdk2.Resource):
    """Market MBO CMS EDITOR API configuration"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBO_CATEGORY(sdk2.Resource):
    """Market MBO Category interface"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBO_CATEGORY_TMS(sdk2.Resource):
    """Market MBO Category TMS"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_LIGHT_MATCHER_APP(sdk2.Resource):
    """Market Light Matcher application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_LIGHT_MATCHER_CONFIG(sdk2.Resource):
    """Market Light Matcher configuration"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_AUTOGENERATION_TMS_APP(sdk2.Resource):
    """Market IR autogeneration-tms application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_AUTOGENERATION_TMS_CONFIG(sdk2.Resource):
    """Market IR autogeneration-tms configuration"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_FORMALIZER_APP(sdk2.Resource):
    """Market IR formalizer application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_IR_FORMALIZER_DATAGETTER_TESTING_JAR(sdk2.Resource):
    """
        Ресурс для формирования выгрузки формализатора для репорта в тестинге
    """
    releasable = True
    releasers = ["MARKET"]


class MARKET_IR_FORMALIZER_DATAGETTER_JAR(sdk2.Resource):
    """
        Ресурс для формирования выгрузки формализатора для репорта
    """
    releasable = True
    releasers = ["MARKET"]


class MARKET_FORMALIZER_CONFIG(sdk2.Resource):
    """Market IR formalizer configuration"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_ALIAS_MAKER_APP(sdk2.Resource):
    """Market IR alias-maker application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_ALIAS_MAKER_CONFIG(sdk2.Resource):
    """Market IR alias-maker configuration"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_ALIAS_MAKER_META_APP(sdk2.Resource):
    """Market IR alias-maker-meta application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_ALIAS_MAKER_META_CONFIG(sdk2.Resource):
    """Market IR alias-maker-meta configuration"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_BOOKS_GENERATOR_APP(sdk2.Resource):
    """Market IR formalizer application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_BOOKS_GENERATOR_CONFIG(sdk2.Resource):
    """Market IR formalizer configuration"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_SUPPLIER_CONTENT_TMS_APP(sdk2.Resource):
    """Market IR supplier-content-tms application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_SUPPLIER_CONTENT_TMS_CONFIG(sdk2.Resource):
    """Market IR supplier-content-tms configuration"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_CONTENT_LAB_API_APP(sdk2.Resource):
    """Market Content Laboratory API application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_CONTENT_LAB_API_CONFIG(sdk2.Resource):
    """Market Content Laboratory API configuration"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_CONTENT_LAB_TMS_APP(sdk2.Resource):
    """Market Content Laboratory TMS application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_CONTENT_LAB_TMS_CONFIG(sdk2.Resource):
    """Market Content Laboratory TMS configuration"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_CONTENT_LAB_UI_APP(sdk2.Resource):
    """Market Content Laboratory UI application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_CONTENT_LAB_UI_CONFIG(sdk2.Resource):
    """Market Content Laboratory UI configuration"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_TEMPLATER_ISS_HOOK_INSTALL(sdk2.Resource):
    """ISS hook install for Templater"""

    executable = True
    releasable = True
    releasers = marketsre


class MARKET_TEMPLATER_ISS_HOOK_START(sdk2.Resource):
    """ISS hook start for Templater"""

    executable = True
    releasable = True
    releasers = marketsre


class MARKET_TEMPLATER(sdk2.Resource):
    """Templater"""

    executable = True
    releasable = True
    releasers = marketsre


class MARKET_EVENTS_VENV(sdk2.Resource):
    """Market events python3 venv"""

    releasable = True
    releasers = market_report


class PORTO_LAYER_MARKET_PRICECHART(sdk2.Resource):
    """Layer with market pricechart daemon"""

    releasable = True
    releasers = market_marketdev_business_backoffice + marketsre
    auto_backup = True


class MARKET_PRICECHART_CONFIG(sdk2.Resource):
    """Market Prichart-gen configuration"""

    releasable = True
    releasers = market_marketdev_business_backoffice + marketsre + robot_market_infra


class MARKET_OTHER(sdk2.Resource):
    """Market random test configuration"""

    releasable = True
    releasers = marketsre


class MARKET_PLAYBOOK_RUNNER(sdk2.Resource):
    """Market ansible-playbook diff validator"""

    releasable = True
    releasers = marketsre


class MARKET_CONTENT_API_APP(sdk2.Resource):
    """Market content-api application"""

    releasable = True
    releasers = marketsre + market_content_api + market_teamcity + robot_market_infra


class MARKET_CONTENT_API_CONFIG(sdk2.Resource):
    """Market content-api configuration"""

    releasable = True
    releasers = marketsre + market_content_api + robot_market_infra


class MARKET_CONTENT_API_CONFIG_TEMPLATE(sdk2.Resource):
    """Market content-api configuration file template"""

    releasable = True
    releasers = marketsre + market_content_api + robot_market_infra


class MARKET_CONTENT_API_MEMCACHED_CONFIG(sdk2.Resource):
    """Memcached for market content-api configuration"""

    releasable = True
    releasers = marketsre + market_content_api + robot_market_infra


class MARKET_FMCG_MAIN_APP(sdk2.Resource):
    """Market fmcg http api application"""

    releasable = True
    releasers = marketsre + market_fmcg + robot_market_infra


class MARKET_FMCG_TMS_APP(sdk2.Resource):
    """Market fmcg tms application"""

    releasable = True
    releasers = marketsre + market_fmcg + robot_market_infra


class MARKET_FMCG_ADMIN_APP(sdk2.Resource):
    """Market fmcg admin application"""

    releasable = True
    releasers = marketsre + market_fmcg + robot_market_infra


class MARKET_FMCG_API_APP(sdk2.Resource):
    """Market fmcg api application"""

    releasable = True
    releasers = marketsre + market_fmcg + robot_market_infra


class MARKET_PERS_LOYALTY_APP(sdk2.Resource):
    """Market PERS Loaylty application"""

    releasable = True
    releasers = marketsre + market_loyalty + market_teamcity + robot_market_infra + robot_mrk_teamcity


class MARKET_PERS_LOYALTY_CONFIG(sdk2.Resource):
    """Market PERS Loyalty configuration"""

    releasable = True
    releasers = marketsre + market_loyalty + market_teamcity + robot_market_infra + robot_mrk_teamcity


class MARKET_PERS_LOYALTY_ADMIN_APP(sdk2.Resource):
    """Market PERS Loyalty Admin application"""

    releasable = True
    releasers = marketsre + market_loyalty + market_teamcity + robot_market_infra + robot_mrk_teamcity


class MARKET_PERS_ADDRESS_CONFIG(sdk2.Resource):
    """Market PERS Address service configuration"""

    releasable = True
    releasers = marketsre + market_pers + market_teamcity + robot_market_infra + robot_mrk_teamcity


class MARKET_PERS_LOYALTY_ADMIN_CONFIG(sdk2.Resource):
    """Market PERS Loyalty Admin configuration"""

    releasable = True
    releasers = marketsre + market_loyalty + robot_market_infra


class MARKET_PERS_LOYALTY_SOLOMON_AGENT_CONFIG(sdk2.Resource):
    """Market PERS Loyalty Solomon Agent configuration"""

    releasable = True
    releasers = marketsre + market_loyalty + robot_market_infra


class MARKET_PERS_LOYALTY_ADMIN_SOLOMON_AGENT_CONFIG(sdk2.Resource):
    """Market PERS Loyalty Admin solomon agent configuration"""

    releasable = True
    releasers = marketsre + market_loyalty + robot_market_infra


class MARKET_PERS_BASKET_APP(sdk2.Resource):
    """Market PERS Basket application"""

    releasable = True
    releasers = marketsre + market_pers + market_teamcity + robot_market_infra + robot_mrk_teamcity


class MARKET_PERS_HISTORY_APP(sdk2.Resource):
    """Market PERS History application"""

    releasable = True
    releasers = marketsre + market_pers + market_teamcity + robot_market_infra


class MARKET_PERS_GRADE_ADMIN_APP(sdk2.Resource):
    """Market PERS Grade Admin application"""

    releasable = True
    releasers = marketsre + market_pers + market_teamcity + robot_market_infra


class MARKET_PERS_GRADE_APP(sdk2.Resource):
    """Market PERS Grade Admin application"""

    releasable = True
    releasers = marketsre + market_pers + market_teamcity + robot_market_infra


class MARKET_PERS_TMS_APP(sdk2.Resource):
    """Market PERS Grade Admin application"""

    releasable = True
    releasers = marketsre + market_pers + market_teamcity + robot_market_infra


class MARKET_MAILER_APP(sdk2.Resource):
    """Market Mailer application"""

    releasable = True
    releasers = marketsre + market_crm_group + market_teamcity + robot_market_infra


class MARKET_DATA_MAILER(MARKET_DATA_OTHER):
    """
        Ресурс data-getter для market-mailer
    """


class MARKET_PERS_STATIC_APP(sdk2.Resource):
    """Market PERS Static application"""

    releasable = True
    releasers = marketsre + market_pers + market_teamcity + robot_market_infra


class MARKET_FRONT_ENVY_SUMMARY(sdk2.Resource):
    """Отчёт об обновлении пакетов envy"""


class MARKET_FRONT_CARRIER_BUNDLE(sdk2.Resource):
    """Market Front Carrier modules bundle"""

    releasable = False
    ttl = 30
    indent = sdk2.Attributes.String("Custom indent", required=True)
    system = sdk2.Attributes.String("Build platform", required=True)
    modules = sdk2.Attributes.String("Node modules version", required=True)
    hash = sdk2.Attributes.String("Locks hash", required=True)


class MARKET_FRONT_DESKTOP_CONFIG(sdk2.Resource):
    """Market Front Desktop configuration"""

    releasable = True
    releasers = marketsre + market_front + robot_market_infra


class MARKET_FRONT_LOG_CLEANER_CONFIG(sdk2.Resource):
    """Market Log Cleaner configuration"""

    releasable = True
    releasers = marketsre + market_front + robot_market_infra


class MARKET_FRONT_BLUE_DESKTOP_CONFIG(sdk2.Resource):
    """Market Front Blue Desktop configuration"""

    releasable = True
    releasers = marketsre + market_front + robot_market_infra


class MARKET_FRONT_TOUCH_CONFIG(sdk2.Resource):
    """Market Front Touch configuration"""

    releasable = True
    releasers = marketsre + market_front + robot_market_infra


class MARKET_FRONT_TOUCH_API_CONFIG(sdk2.Resource):
    """Market Front Touch API configuration"""

    releasable = True
    releasers = marketsre + market_front + robot_market_infra


class MARKET_FRONT_BLUE_TOUCH_CONFIG(sdk2.Resource):
    """Market Front Touch configuration"""

    releasable = True
    releasers = marketsre + market_front + robot_market_infra


class MARKET_FRONT_API_CONFIG(sdk2.Resource):
    """Market Front API configuration"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_FRONT_RED_DESKTOP_CONFIG(sdk2.Resource):
    """Market Front Red Desktop configuration"""

    releasable = True
    releasers = ["MARKETREDDEV"]


class MARKET_FRONT_BLACK_DESKTOP_CONFIG(sdk2.Resource):
    """Market Front Black Desktop configuration"""

    releasable = True
    releasers = marketsre + market_front + robot_market_infra


class MARKET_FRONT_MF_CORE_CONFIG(MarketFrontCommonResource):
    """Market Core Microfront configuration"""


class MARKET_TICKETS_SUMMONEER_APP(sdk2.Resource):
    """TicketsSummoneer binary"""
    releasable = True
    releasers = ["MARKET"]


class MARKET_FRONT_HANSEL_APP(sdk2.Resource):
    """Hansel binary"""
    releasable = True
    releasers = ["MARKET"]


class MARKET_FRONT_HANSEL_CONFIG(sdk2.Resource):
    """Hansel configuration"""
    releasable = True
    releasers = ["MARKET"]


class MARKET_PRICE_CENTER_APP(sdk2.Resource):
    """Market price-center application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_PRICE_CENTER_CONFIG(sdk2.Resource):
    """Market price-center configuration"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MSTAT_COPY_YT_TO_CH_APP(sdk2.Resource):
    """Transfer Manager copy_table_yt_to_clickhouse application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBI_RC_MANAGEMENT_AGENT(sdk2.Resource):
    """Runtime Cloud management agent"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_FULFILLMENT_STOCK_STORAGE_APP(sdk2.Resource):
    """Market Fulfillment Stock Storage application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_FULFILLMENT_STOCK_STORAGE_CONFIG(sdk2.Resource):
    """Market Fulfillment Stock Storage config"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_FF_DYNAMIC_UPLOADER_BINARY(sdk2.Resource):
    """Market utiltiy for generating sku-available file"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_FF_SKU_AVAILABILITY_UPLOADER_BINARY(sdk2.Resource):
    """Market utiltiy for generating sku-available file"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_CAMPAIGN_MANAGEMENT_APP(sdk2.Resource):
    """Market LiluCRM campaign management application"""

    releasable = True
    releasers = marketsre + market_ex_content_api + market_teamcity + robot_market_infra


class MARKET_CAMPAIGN_MANAGEMENT_CONFIG(sdk2.Resource):
    """Market LiluCRM campaign management app configuration"""

    releasable = True
    releasers = marketsre + market_ex_content_api + robot_market_infra


class MARKET_GRADE_MARKET_BANNER_CONFIG(sdk2.Resource):
    """Market grade.market.yandex.ru app configuration"""

    releasable = True
    releasers = marketsre + robot_market_infra + ['MARKET_GRADE_MARKET_BANNER_ADMINS']


class MARKET_FULFILLMENT_WORKFLOW_API_APP(sdk2.Resource):
    """Market Fulfillment Workflow application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_FULFILLMENT_WORKFLOW_API_CONFIG(sdk2.Resource):
    """Market Fulfillment Workflow configuration"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_FULFILLMENT_FFWRAP_ITELLA_APP(sdk2.Resource):
    """Market Fulfillment ITELLA Wrap application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_FULFILLMENT_FFWRAP_ITELLA_CONFIG(sdk2.Resource):
    """Market Fulfillment ITELLA Wrap config"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_FULFILLMENT_FFWRAP_MARSCHROUTE_APP(sdk2.Resource):
    """Market Fulfillment MARSCHROUTE Wrap application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_FULFILLMENT_FFWRAP_MARSCHROUTE_CONFIG(sdk2.Resource):
    """Market Fulfillment MARSCHROUTE Wrap config"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_STAT_ANTIFRAUD_ONLINE_APP(sdk2.Resource):
    """Market Stat Antifraud-Online Wrap application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_STAT_ANTIFRAUD_ONLINE_CONFIG(sdk2.Resource):
    """Market Stat Antifraud-Online Wrap config"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_STAT_ANTIFRAUD_PGAAS_APP(sdk2.Resource):
    """Market Stat Antifraud-Pgaas Wrap application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_STAT_ANTIFRAUD_PGAAS_CONFIG(sdk2.Resource):
    """Market Stat Antifraud-Pgaas Wrap config"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_STAT_ANTIFRAUD_PGAAS_NGINX_CONFIG(sdk2.Resource):
    """Market Stat Antifraud-Pgaas nginx config"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MONETIZATION_CLICKDAEMON_CONFIGS(sdk2.Resource):
    """Market Monetization Clickdaemon configs"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_CLICKDAEMON_EXECUTABLE(sdk2.Resource):
    """Market Monetization clickdaemon executable binary"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_STAT_ANTIFRAUD_YQL_APP(sdk2.Resource):
    """Market Stat Antifraud-Yql Wrap application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_STAT_ANTIFRAUD_YQL_CONFIG(sdk2.Resource):
    """Market Stat Antifraud-Yql Wrap config"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_STAT_DICTIONARIES_YT_APP(sdk2.Resource):
    """Market Stat Dictionaries-YT Wrap application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_STAT_DICTIONARIES_YT_CONFIG(sdk2.Resource):
    """Market Stat Dictionaries-YT Wrap config"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_STAT_REPORTING_API_BACKEND_APP(sdk2.Resource):
    """Market Stat Reporting Api Backend Wrap application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_STAT_REPORTING_API_BACKEND_CONFIG(sdk2.Resource):
    """Market Stat Reporting Api Backend Wrap config"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_STAT_YT_PUSH_CLIENT_APP(sdk2.Resource):
    """Market Stat Yt Push Client Wrap application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_STAT_YT_PUSH_CLIENT_CONFIG(sdk2.Resource):
    """Market Stat Yt Push Client Wrap config"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBI_DELIVERY_CALCULATOR_INDEXER_APP(sdk2.Resource):
    """MBI Delivery Calculator Indexer application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBI_DELIVERY_CALCULATOR_SEARCH_ENGINE_APP(sdk2.Resource):
    """MBI Delivery Calculator Search Engine application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_PRICELABS_API_APP(sdk2.Resource):
    """PriceLabs API application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_FRONT_ABO_VIEW(sdk2.Resource):
    """Market abo view yandex-abo-view-x5 """

    releasable = True
    releasers = marketsre + market_marketdev_business_backoffice + robot_market_infra + market_teamcity


class MARKET_FRONT_ABO_CONF(sdk2.Resource):
    """Market front abo configs """

    releasable = True
    releasers = marketsre + market_marketdev_business_backoffice + robot_market_infra + market_teamcity


class MARKET_FRONT_MBO_VIEW(sdk2.Resource):
    """Market mbo view yandex-mbo-view-x5 """

    releasable = True
    releasers = marketsre + market_marketdev_business_mining + robot_market_infra + market_teamcity


class MARKET_FRONT_MBO_CLASSIFIER_OPERATOR_UI_VIEW(sdk2.Resource):
    """Market mbo view yandex-mbo-classifier-operator-ui """

    releasable = True
    releasers = marketsre + market_marketdev_business_mining + robot_market_infra + market_teamcity


class MARKET_FRONT_MBO_CLASSIFIER_UI_VIEW(sdk2.Resource):
    """Market mbo view yandex-mbo-classifier-ui """

    releasable = True
    releasers = marketsre + market_marketdev_business_mining + robot_market_infra + market_teamcity


class MARKET_FRONT_MBO_GURULITE_UI_VIEW(sdk2.Resource):
    """Market mbo view yandex-mbo-gurulight-ui"""

    releasable = True
    releasers = marketsre + market_marketdev_business_mining + robot_market_infra + market_teamcity


class MARKET_FRONT_MBO_CONF(sdk2.Resource):
    """Market front mbo configs """

    releasable = True
    releasers = marketsre + market_marketdev_business_mining + robot_market_infra + market_teamcity


class MARKET_FRONT_CONTENT_MAPPING_CONF(sdk2.Resource):
    """Market front content mapping configs """

    releasable = True
    releasers = marketsre + market_marketdev_business_mining + robot_market_infra + market_teamcity


class MARKET_FRONT_CMS_CONF(sdk2.Resource):
    """Market front cms configs """

    releasable = True
    releasers = marketsre + market_marketdev_business_mining + robot_market_infra + market_teamcity


class MARKET_OPERATOR_WINDOW_APP(sdk2.Resource):
    """Market LiluCRM operator window application"""

    releasable = True
    releasers = marketsre + market_ocrm + market_teamcity + robot_market_infra


class MARKET_OPERATOR_WINDOW_WEBAPP(sdk2.Resource):
    """Market LiluCRM operator window webapp"""

    releasable = True
    releasers = marketsre + market_ocrm + market_teamcity + robot_market_infra


class MARKET_OPERATOR_WINDOW_CONFIG(sdk2.Resource):
    """Market LiluCRM operator window app configuration"""

    releasable = True
    releasers = marketsre + market_ocrm + robot_market_infra


class MARKET_CONTENT_API_ADMIN_APP(sdk2.Resource):
    """Market content-api admin application"""

    releasable = True
    releasers = marketsre + market_content_api + market_teamcity + robot_market_infra


class MARKET_CONTENT_API_ADMIN_APP_CONFIG(sdk2.Resource):
    """Market content-api admin application configuration"""

    releasable = True
    releasers = marketsre + market_content_api + robot_market_infra


class MARKET_FRONT_SITEMAP_CONFIG(sdk2.Resource):
    """Market front sitemap configuration"""

    releasable = True
    releasers = marketsre + robot_market_infra


class MARKET_FRONT_CMS_RSS_CONFIG(sdk2.Resource):
    """Market front sitemap configuration"""

    releasable = True
    releasers = marketsre + robot_market_infra


class MARKET_JUGGLER_RTC_CHECKS_BUNDLE(sdk2.Resource):
    """Bundle with all RTC checks"""

    releasable = True
    auto_backup = True


class MARKET_MBI_BALANCE_PROXY_APP(sdk2.Resource):
    """Market MBI Balance proxy app"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_SAAS_HUB_BINARY(sdk2.Resource):
    """Market SAAS HUB binary"""

    ttl = 30
    releasable = True
    releasers = marketsre + ["razmser", "iddqd", "robot-market-infra"]


class MARKET_SAAS_HUB_CONFIG(sdk2.Resource):
    """Market SAAS HUB configs"""

    ttl = 30
    releasable = True
    releasers = marketsre + ["razmser", "iddqd", "robot-market-infra"]


class MARKET_PARTNER_API_APP(sdk2.Resource):
    """Market Partner API application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_PARTNER_API_CONFIG(sdk2.Resource):
    """Market Partner API config"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBI_MARKET_QA_APP(sdk2.Resource):
    """Market MBI Market QA app"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBI_ADMIN_UI(sdk2.Resource):
    """Market mbi admin ui"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_DELIVERY_CALCULATOR_CONFIG(sdk2.Resource):
    """Market mbi delivery calculator"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_SNIPPET_ADMIN_VIEW(sdk2.Resource):
    """Market mbi snippet admin view"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_JAVA_SEC_EDITOR_UI(sdk2.Resource):
    """Market java sec editor ui"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_PERS_GRADE_ADMIN_VIEW(sdk2.Resource):
    """Market PERS grade admin view x5"""

    releasable = True
    releasers = marketsre + market_pers + market_teamcity + robot_market_infra


class MARKET_PERS_QA(sdk2.Resource):
    """Market PERS Q&A"""

    releasable = True
    releasers = marketsre + market_pers + market_teamcity + robot_market_infra


class MARKET_PERS_QA_TMS(sdk2.Resource):
    """Market PERS Q&A TMS"""

    releasable = True
    releasers = marketsre + market_pers + market_teamcity + robot_market_infra


class MARKET_PERS_QA_ADMIN(sdk2.Resource):
    """Market PERS Q&A Admin"""

    releasable = True
    releasers = marketsre + market_pers + market_teamcity + robot_market_infra


class MARKET_MBI_ADMIN_UI_CONFIG(sdk2.Resource):
    """Market front mbi-admin configuration"""

    releasable = True
    releasers = marketsre + robot_market_infra + market_teamcity + ["MARKET-MBI"]


class MARKET_SNIPPET_ADMIN_VIEW_CONFIG(sdk2.Resource):
    """Market front snippet admin configuration"""

    releasable = True
    releasers = marketsre + robot_market_infra + market_teamcity


class MARKET_JAVA_SEC_EDITOR_UI_CONFIG(sdk2.Resource):
    """Market front java sec editor ui configuration"""

    releasable = True
    releasers = marketsre + robot_market_infra + market_teamcity


class MARKET_PERS_GRADE_ADMIN_VIEW_CONFIG(sdk2.Resource):
    """Market front pers grade admin view configuration"""

    releasable = True
    releasers = marketsre + robot_market_infra + market_teamcity


class MARKET_METRICS_CONFIG(sdk2.Resource):
    """Json description of market constructor metrics"""

    releasable = True


class MARKET_METRICS_CONSTRUCTOR_EXECUTABLE(sdk2.Resource):
    """Executable file of market constructor metrics"""

    releasable = True
    executable = True


class MARKET_EMPTY_APP(sdk2.Resource):
    """Market empty application"""

    releasable = True
    releasers = marketsre + robot_market_infra + market_teamcity


class MARKET_EMPTY_CONFIG(sdk2.Resource):
    """Market empty configuration"""

    releasable = True
    releasers = marketsre + robot_market_infra + market_teamcity


class MARKET_EMPTY_NODEJS_APP(sdk2.Resource):
    """Market empty NodeJS application"""

    releasable = True
    releasers = marketsre + robot_market_infra + market_teamcity


class MARKET_PRICELABS_TMS_APP(sdk2.Resource):
    """PriceLabs TMS application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_CHECKOUTER_APP(sdk2.Resource):
    """Market Checkout checkouter application"""

    releasable = True

    releasable = True
    releasers = ["MARKET"]


class MARKET_CHECKOUTER_CONFIG(sdk2.Resource):
    """Market Checkout checkouter configuration"""

    releasable = True

    releasable = True
    releasers = ["MARKET"]


class MARKET_IDX_FEEDPARSER_APP(sdk2.Resource):
    """Legacy Market Indexer feedparser application"""

    releasable = True
    releasers = market_idx_group + market_sre_group + robot_market_infra + market_teamcity


class MARKET_FEEDPARSER_APP(sdk2.Resource):
    """Market Indexer feedparser application"""

    ttl = 30
    releasable = True
    releasers = market_idx_group + market_sre_group + robot_market_infra + market_teamcity


class MARKET_PUSH_FEEDPARSER_APP(sdk2.Resource):
    """Market Indexer feedparser application for push schema"""

    ttl = 30
    releasable = True
    releasers = market_idx_group + market_sre_group + robot_market_infra + market_teamcity


class MARKET_QPARSER_APP(sdk2.Resource):
    """Market Indexer qparser application for push schema"""

    ttl = 30
    releasable = True
    releasers = market_idx_group + market_sre_group + robot_market_infra + market_teamcity


class MARKET_IDX_OFFERS_ROBOT_APP(sdk2.Resource):
    """Market Indexer offers robot application"""

    releasable = True
    releasers = market_idx_group + market_sre_group + robot_market_infra + market_teamcity


class MARKET_IDX_OFFERS_ROBOT_CONFIG(sdk2.Resource):
    """Market Indexer offers robot configuration"""

    releasable = True
    releasers = market_idx_group + market_sre_group + robot_market_infra + market_teamcity


class MARKET_OFFERS_ROBOT_APP(sdk2.Resource):
    """Market Indexer offers robot application"""

    releasable = True
    releasers = market_idx_group + market_sre_group + robot_market_infra + market_teamcity


class MARKET_OFFERS_ROBOT_CONFIG(sdk2.Resource):
    """Market Indexer offers robot configuration"""

    releasable = True
    releasers = market_idx_group + market_sre_group + robot_market_infra + market_teamcity


class MARKET_INDEXER_APP(sdk2.Resource):
    """Market indexer application"""

    releasable = True
    releasers = market_idx_group + market_sre_group + robot_market_infra + market_teamcity


class MARKET_MARKETINDEXER_APP(sdk2.Resource):
    """Market marketindexer application"""

    releasable = True
    releasers = market_idx_group + market_sre_group + robot_market_infra + market_teamcity


class MARKET_YELLOWINDEXER_CONFIG(sdk2.Resource):
    """Market yellowindexer configuration"""

    releasable = True
    releasers = market_idx_group + market_sre_group + robot_market_infra + market_teamcity


class MARKET_YELLOWINDEXER_APP(sdk2.Resource):
    """Market yellowindexer application"""

    ttl = 30
    releasable = True
    releasers = market_idx_group + market_sre_group + robot_market_infra + market_teamcity


class MARKET_DATA_YELLOWINDEXER(MARKET_DATA_OTHER):
    '''Ресурс data-getter для yellowindexer'''


class MARKET_DATA_YELLOWINDEXER_GENDATA(MARKET_DATA_OTHER):
    '''Ресурс с поколенчатыми данными yellowindexer, ресуры из data-getter + статистика'''

    releasers = market_idx_group + market_sre_group


class MARKET_DATA_OFFERS_ROBOT2(MARKET_DATA_OTHER):
    """Ресурс data-getter для Offers-robot2"""


class MARKET_DATA_DATACAMP_PARSER(MARKET_DATA_OTHER):
    """Ресурс data-getter для push-parser"""


class MARKET_DATA_DATACAMP_MINER(MARKET_DATA_OTHER):
    """Ресурс data-getter для miner"""


class MARKET_DATA_DATACAMP_MINER_MSKU(MARKET_DATA_OTHER):
    """Ресурс data-getter для miner-msku"""


class MARKET_DATA_DATACAMP_MINER_EXTERNAL(MARKET_DATA_OTHER):
    """Ресурс data-getter для miner-external"""


class MARKET_DATA_SHOPSDAT(MARKET_DATA_OTHER):
    """Ресурс shops.dat"""


class MARKET_DATA_DATACAMP_CONTROLLERS(MARKET_DATA_OTHER):
    """Ресурс c файлами для контроллеров, например, currency_rates.xml"""


class MARKET_DATA_DATACAMP_DELIVERYDIFF(MARKET_DATA_OTHER):
    """Ресурс c файлами geobase для Datacamp.Routines.DeliveryDiff таски, высчитывающей наличие доставки"""


class MARKET_DATA_SAILOR(MARKET_DATA_OTHER):
    """
        Ресурс для сервиса Sailor
        см. MARKETOUT-31149
    """


class MARKET_IDX_IDXAPI_APP(sdk2.Resource):
    """Legacy Market Indexer IDXAPI application"""

    releasable = True
    releasers = market_idx_group + market_sre_group + robot_market_infra + market_teamcity


class MARKET_IDXAPI_APP(sdk2.Resource):
    """Market Indexer IDXAPI application"""

    ttl = 30
    releasable = True
    releasers = market_idx_group + market_sre_group + robot_market_infra + market_teamcity


class MARKET_IDX_IDXAPI_CONFIG(sdk2.Resource):
    """Legacy Market Indexer IDXAPI configuration"""

    releasable = True
    releasers = market_idx_group + market_sre_group + robot_market_infra + market_teamcity


class MARKET_IDXAPI_CONFIG(sdk2.Resource):
    """Market Indexer IDXAPI configuration"""

    releasable = True
    releasers = market_idx_group + market_sre_group + robot_market_infra + market_teamcity


class MARKET_IDXAPI_INFRA_CONFIG_DEPLOY(sdk2.Resource):
    """Market idxapi config for infra box"""

    releasable = True
    releasers = market_idx_group + market_sre_group + robot_market_infra + market_teamcity


class MARKET_DATA_IDXAPI(MARKET_DATA_OTHER):
    '''Ресурс data-getter для idxapi'''


class MARKET_CHECKOUT_PUSH_API_APP(sdk2.Resource):
    """Market Checkout push-api application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_CHECKOUT_PUSH_API_CONFIG(sdk2.Resource):
    """Market Checkout push-appi configuration"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_CARTER_APP(sdk2.Resource):
    """Market Checkout carter application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_DATA_CHECKOUT_PUSH_API(MARKET_DATA_OTHER):
    """
        Ресурс data-getter для push-api
    """


class MARKET_CARTER_CONFIG(sdk2.Resource):
    """Market Checkout carter configuration"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_RESERVATION_FEATURES(sdk2.Resource):
    """Market Reservation features configuration"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_DELIVERY_PARTNER_API_MOCK_APP(sdk2.Resource):
    """Market Delivery Partner API Mock application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_DELIVERY_PARTNER_API_MOCK_CONFIG(sdk2.Resource):
    """Market Delivery Partner API Mock config"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_CLICKHOUSE_DEALER_APP(sdk2.Resource):
    """Market ClickHouse Dealer application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_CLICKHOUSE_DEALER_CONFIG(sdk2.Resource):
    """Market ClickHouse Dealer configs"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_PBUILDER_IMAGE(sdk2.resource.AbstractResource):
    """
        The result of pbuilder --create
    """


class MARKET_DELIVERY_TRACKER_APP(sdk2.Resource):
    """Market Delivery Tracker application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_DELIVERY_TRACKER_CONFIG(sdk2.Resource):
    """Market Delivery Tracker config"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_TRANSPORT_MANAGER_CONFIG(sdk2.Resource):
    """Market Transport Manager config"""
    releasable = True
    releasers = ["MARKET"]


class MARKET_TSUP_CONFIG(sdk2.Resource):
    """Market TSUP config"""
    releasable = True
    releasers = ["MARKET"]


class MARKET_LES_CONFIG(sdk2.Resource):
    """Market LES config"""
    releasable = True
    releasers = ["MARKET"]


class MARKET_LOGISTICS_MANAGEMENT_APP(sdk2.Resource):
    """Market Logistics Management Service application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_DATA_LOGISTICS_MANAGEMENT(MARKET_DATA_OTHER):
    """
        Ресурс data-getter для Market Logistics Management Service
    """


class MARKET_LOGISTICS_MANAGEMENT_CONFIG(sdk2.Resource):
    """Market Logistics Management Service config"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_WRAP_INFOR_APP(sdk2.Resource):
    """Market Wrap Infor Service application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_WRAP_INFOR_CONFIG(sdk2.Resource):
    """Market Wrap Infor Service config"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_LOGISTIC_GATEWAY_APP(sdk2.Resource):
    """Market Logistic Gateway Service application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_LOGISTIC_GATEWAY_CONFIG(sdk2.Resource):
    """Market Logistic Gateway Service config"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_YANDEX_BALANCER_BINARY(sdk2.Resource):
    """Yandex balancer binary from Market"""

    releasable = True
    releasers = marketsre


class MARKET_MBI_ADMIN_APP(sdk2.Resource):
    """Market mbi-admin backend application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_PLATFORM_APP(sdk2.Resource):
    """Market LiluCRM Platform application"""

    releasable = True
    releasers = marketsre + market_ex_content_api + market_teamcity + robot_market_infra


class MARKET_PLATFORM_CONFIG(sdk2.Resource):
    """Market LiluCRM Platform app configuration"""

    releasable = True
    releasers = marketsre + market_ex_content_api + robot_market_infra


class MARKET_PLATFORM_READER_APP(sdk2.Resource):
    """Market LiluCRM Platform Reader application"""

    releasable = True
    releasers = marketsre + market_ex_content_api + robot_market_infra + ['MARKET-MBI']


class MARKET_PLATFORM_READER_APP_CONFIG(sdk2.Resource):
    """Market LiluCRM Platform Reader application configuration"""

    releasable = True
    releasers = marketsre + market_ex_content_api + robot_market_infra


class MARKET_PLATFORM_API_APP_CONFIG(sdk2.Resource):
    """Market LiluCRM Platform Api application configuration"""

    releasable = True
    releasers = marketsre + market_ex_content_api + robot_market_infra


class MARKET_SCANTOBUY_APP(sdk2.Resource):
    """Market STB application"""

    releasable = True
    releasers = marketsre + market_scantobuy


class MARKET_SCANTOBUY_CONFIG(sdk2.Resource):
    """Market STB configs"""

    releasable = True
    releasers = marketsre + market_scantobuy


class MARKET_PLATFORM_SBER_APP(sdk2.Resource):
    """Market LiluCRM Platform Sber application"""

    releasable = True
    releasers = marketsre + market_ex_content_api + robot_market_infra


class MARKET_TRIGGERS_PLATFORM_APP(sdk2.Resource):
    """Market LiluCRM Triggets Platform application"""

    releasable = True
    releasers = marketsre + market_ex_content_api + robot_market_infra


class MARKET_TRIGGERS_PLATFORM_APP_CONFIG(sdk2.Resource):
    """Market LiluCRM Triggets Platform configuration"""

    releasable = True
    releasers = marketsre + market_ex_content_api + robot_market_infra


class MARKET_PGAAS_TOOL(sdk2.Resource):
    """Market pgaas-tool app"""

    releasable = True
    releasers = marketsre + robot_market_infra


class MARKET_PGAAS_TOOL_MAC(sdk2.Resource):
    """Market pgaas-tool app"""

    releasable = True
    releasers = marketsre + robot_market_infra


class MARKET_TEMPLATE_JAVA_APP(sdk2.Resource):
    """Market Template Java application"""

    releasable = True
    releasers = ["MARKET"]
    auto_backup = True


class MARKET_MBI_DELIVERY_CALCULATOR_LQB_DATA_APP(sdk2.Resource):
    """Market MBI Delivery Calculator Liquibase Migration application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_KADAVR_APP(MarketFrontCommonResource):
    """Kadavr app"""


class MARKET_APP(sdk2.Resource):
    """Market application"""
    any_arch = True
    __default_attribute__ = sdk2.parameters.String


class MARKET_AUTOTEST_REPORT(sdk2.Resource):
    """Allure autotest report"""
    any_arch = True
    __default_attribute__ = sdk2.parameters.String


class MARKET_AUTOTEST_STATS(sdk2.Resource):
    """Statistics of a test run"""
    any_arch = True
    __default_attribute__ = sdk2.parameters.String


class MARKET_AUTOTEST_ERRORS(sdk2.Resource):
    """Errors of a test run"""
    any_arch = True
    __default_attribute__ = sdk2.parameters.String


class MARKET_BROKEN_AUTOTEST_REPORT(sdk2.Resource):
    """List of broken autotests report"""
    any_arch = True
    __default_attribute__ = sdk2.parameters.String

    reference_resource_id = sdk2.parameters.String("Reference resource id", required=False)


class MARKET_TESTPALM_IDS(sdk2.Resource):
    """List of testpalm ids"""
    any_arch = True
    __default_attribute__ = sdk2.parameters.String


class MARKET_SCREENSHOTS_PACK(sdk2.Resource):
    """Gemini screenshots pack"""
    any_arch = True
    __default_attribute__ = sdk2.parameters.String


class MARKET_KADAVR_CONFIG(sdk2.Resource):
    """Market Front Blue Desktop configuration"""

    releasable = True
    releasers = marketsre + market_front + robot_market_infra


class MARKET_OLAP2_ETL(sdk2.Resource):
    """Olap2 ETL app"""

    releasable = True

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBI_API_APP(sdk2.Resource):
    """Market mbi-api application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBI_API_APP_DEPLOY(sdk2.Resource):
    """Market mbi-api application for deploy"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_VIEWED_MODELS_BY_USER_APP(sdk2.Resource):
    """st/MARKETOUT-17519
    """

    releasable = True
    releasers = marketsre + robot_market_infra + ['manushkin', 'mpdenise', 'dyatsyuk']


class MARKET_REPORT_GENERATOR_APP(sdk2.Resource):
    """Market MBI report-generator application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_REPORT_GENERATOR_CONFIG(sdk2.Resource):
    """Market MBI report-generator config"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBI_PREMODERATION_APP(sdk2.Resource):
    """Market mbi-premoderation application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBI_PREMODERATION_CONFIG(sdk2.Resource):
    """Market mbi-premoderation config"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_URLCHECKER_APP(sdk2.Resource):
    """Market urlchecker application"""

    releasable = True
    releasers = ['MARKET-ABO'] + marketsre + market_teamcity + robot_market_infra


class MARKET_PRICECHART_INFO_APP(sdk2.Resource):
    """Market pricechart-info application"""

    releasable = True
    releasers = ['MARKET-ABO'] + marketsre + market_teamcity + robot_market_infra


class MARKET_CHECKOUT_REFEREE_APP(sdk2.Resource):
    """Market checkout-referee application"""

    releasable = True
    releasers = ['MARKET-ABO'] + marketsre + market_teamcity + robot_market_infra


class MARKET_ABO_MAIN_APP(sdk2.Resource):
    """Market abo-main application"""

    releasable = True
    releasers = ['MARKET-ABO'] + marketsre + market_teamcity + robot_market_infra


class MARKET_ABO_PUBLIC_APP(sdk2.Resource):
    """Market abo-public application"""

    releasable = True
    releasers = ['MARKET-ABO'] + marketsre + market_teamcity + robot_market_infra


class MARKET_ABO_TMS_APP(sdk2.Resource):
    """Market abo-tms application"""

    releasable = True
    releasers = ['MARKET-ABO'] + marketsre + market_teamcity + robot_market_infra


class MARKET_MBI_BILLING_APP(sdk2.Resource):
    """Market mbi-billing application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBI_BILLING_CONFIG(sdk2.Resource):
    """Market mbi-billing config for autoconfigurations"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBI_BILLING_DATA(MARKET_DATA_OTHER):
    """Data-getter resource for mbi-billing"""


class MARKET_MBI_SHOP_TMS_APP(sdk2.Resource):
    """Market mbi-shop-tms application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBI_SHOP_TMS_DATA(MARKET_DATA_OTHER):
    """Data-getter resource for mbi-shop-tms"""


class MARKET_FORECASTER_APP(sdk2.Resource):
    """Forecaster service application"""

    releasable = True
    releasers = ["MARKETMONEY", "MARKETSRE"] + robot_market_infra


class MARKET_FORECASTER_DATA(MARKET_DATA_OTHER):
    """Data package for Forecaster service"""


class MARKET_DATACAMP_PIPER_APP(sdk2.Resource):
    """Offer storage piper application"""

    ttl = 30
    releasable = True
    releasers = marketsre + robot_market_infra + market_idx_group


class MARKET_DATACAMP_PIPER_APP_DEPLOY(sdk2.Resource):
    """Offer storage piper application for yandex deploy"""

    ttl = 30
    releasable = True
    releasers = marketsre + robot_market_infra + market_idx_group


class MARKET_DATACAMP_PIPER_INFRA_CONFIG_DEPLOY(sdk2.Resource):
    """Offer storage piper infra-box configs for yandex deploy"""

    auto_backup = True
    ttl = 365
    releasable = True
    releasers = marketsre + robot_market_infra + market_idx_group


class MARKET_DATACAMP_SCANNER_APP_DEPLOY(sdk2.Resource):
    """Offer storage scanner application for yandex deploy"""

    auto_backup = True
    ttl = 365
    releasable = True
    releasers = marketsre + robot_market_infra + market_idx_group


class MARKET_DATACAMP_SCANNER_INFRA_CONFIG_DEPLOY(sdk2.Resource):
    """Offer storage scanner infra-box configs for yandex deploy"""

    auto_backup = True
    ttl = 365
    releasable = True
    releasers = marketsre + robot_market_infra + market_idx_group


class MARKET_IDX_LBDUMPER_UC_APP(sdk2.Resource):
    """LBDumper-UC application"""

    ttl = 30
    releasable = True
    releasers = marketsre + robot_market_infra + market_idx_group


class MARKET_AMORE_LBDUMPER_APP(sdk2.Resource):
    """AMORE-LBDumper application"""

    ttl = 30
    releasable = True
    releasers = marketsre + robot_market_infra + market_idx_group


class MARKET_AMORE_WORKER_APP(sdk2.Resource):
    """AMORE-Worker application"""

    ttl = 30
    releasable = True
    releasers = marketsre + robot_market_infra + market_idx_group


class MARKET_DATACAMP_STROLLER_APP(sdk2.Resource):
    """Offer storage synchronous controller application"""

    ttl = 30
    releasable = True
    releasers = marketsre + robot_market_infra + market_idx_group


class MARKET_DATACAMP_STROLLER_APP_DEPLOY(sdk2.Resource):
    """Offer storage synchronous controller application"""

    ttl = 30
    releasable = True
    releasers = marketsre + robot_market_infra + market_idx_group


class MARKET_DATACAMP_STROLLER_INFRA_CONFIG_DEPLOY(sdk2.Resource):
    """Configs for stroller's infra box in YD"""

    auto_backup = True
    ttl = 365
    releasable = True
    releasers = marketsre + robot_market_infra + market_idx_group


class MARKET_DATACAMP_ROUTINES_APP(sdk2.Resource):
    """Offer storage routines application"""

    ttl = 30
    releasable = True
    releasers = marketsre + robot_market_infra + market_idx_group


class MARKET_DATACAMP_ROUTINES_APP_DEPLOY(sdk2.Resource):
    """Offer storage routines application in YD"""

    ttl = 30
    releasable = True
    releasers = marketsre + robot_market_infra + market_idx_group


class MARKET_DATACAMP_ROUTINES_INFRA_CONFIG_DEPLOY(sdk2.Resource):
    """Configs for routines's infra box in YD"""

    auto_backup = True
    ttl = 365
    releasable = True
    releasers = marketsre + robot_market_infra + market_idx_group


class MARKET_DATACAMP_PARSER_APP(sdk2.Resource):
    """Offer storage parser application"""

    ttl = 30
    releasable = True
    releasers = marketsre + robot_market_infra + market_idx_group


class MARKET_DATACAMP_PARSER_APP_DEPLOY(sdk2.Resource):
    """Offer storage parser application for yandex deploy"""

    ttl = 30
    releasable = True
    releasers = marketsre + robot_market_infra + market_idx_group


class MARKET_DATACAMP_PARSER_INFRA_CONFIG_DEPLOY(sdk2.Resource):
    """Configs for infra box of parser app"""

    auto_backup = True
    ttl = 365
    releasable = True
    releasers = marketsre + robot_market_infra + market_idx_group


class MARKET_DATACAMP_MINER_APP(sdk2.Resource):
    """Offer storage miner application"""

    ttl = 30
    releasable = True
    releasers = marketsre + robot_market_infra + market_idx_group


class MARKET_DATACAMP_MINER_CONFIGS(sdk2.Resource):
    ttl = 30
    releaseable = True
    releasers = marketsre + robot_market_infra + market_idx_group


class MARKET_DATACAMP_DISPATCHER_APP_DEPLOY(sdk2.Resource):
    """Offer storage dispatcher application for yandex deploy"""

    ttl = 30
    releasable = True
    releasers = marketsre + robot_market_infra + market_idx_group


class MARKET_DATACAMP_DISPATCHER_INFRA_CONFIG_DEPLOY(sdk2.Resource):
    """Configs for infra box of dispatcher app"""

    auto_backup = True
    ttl = 365
    releasable = True
    releasers = marketsre + robot_market_infra + market_idx_group


class MARKET_DATACAMP_MINER_APP_DEPLOY(sdk2.Resource):
    """Offer storage miner application for yandex deploy"""

    ttl = 30
    releasable = True
    releasers = marketsre + robot_market_infra + market_idx_group


class MARKET_DATACAMP_MINER_INFRA_CONFIG_DEPLOY(sdk2.Resource):
    """Configs for infra box of miner app"""

    auto_backup = True
    ttl = 365
    releasable = True
    releasers = marketsre + robot_market_infra + market_idx_group


class MARKET_SHOPINFO_APP(sdk2.Resource):
    """Market shopinfo application"""

    releasable = True
    releasers = ["MARKET-MBI"] + marketsre + market_teamcity + robot_market_infra


class MARKET_CS_ACCESS_RULES_API_APP(sdk2.Resource):
    """Market cs-access-rules-api application"""

    releasable = True
    releasers = ["MARKET-MBI"] + marketsre + market_teamcity + robot_market_infra


class MARKET_REPORT_TVM_TOOL_BINARY(sdk2.Resource):
    """Tvmtool daemon"""

    releasable = True
    releasers = marketsre + market_report + robot_market_infra


class MARKET_MBI_CRM_PROXY_APP(sdk2.Resource):
    """Market MBI to CRM proxy application"""

    releasable = True
    releasers = ["MARKET-MBI"] + marketsre + market_teamcity + robot_market_infra


class MARKET_MODEL_PARAMS_APP(sdk2.Resource):
    """Market model-params application"""

    releasable = True
    releasers = marketsre + market_pers + market_teamcity + robot_market_infra


class MARKET_DATA_MODEL_PARAMS(MARKET_DATA_OTHER):
    """
        Ресурс data-getter для model-params
    """


class MARKET_JAVA_SEC_EDITOR_APP(sdk2.Resource):
    """Market JSM backend application"""

    releasable = True
    releasers = ["MARKET-MBI"] + marketsre + market_teamcity + robot_market_infra


class MARKET_SNIPPET_ADMIN_APP(sdk2.Resource):
    """Market snippet-admin application"""

    releasable = True
    releasers = ["MARKET-MBI"] + marketsre + market_teamcity + robot_market_infra


class MARKET_VENDOR_PARTNER_APP(sdk2.Resource):
    """Market vendor-partner application"""

    releasable = True
    releasers = marketsre + market_teamcity + robot_market_infra


class MARKET_DATA_VENDOR_PARTNER(MARKET_DATA_OTHER):
    """
        Ресурс data-getter для vendor-partner
    """


class MARKET_DATA_REDMARKET_TMS(MARKET_DATA_OTHER):
    """
        Ресурс data-getter для redmarket-tms
    """


class MARKET_WIZARD_DATA(sdk2.Resource):
    """New Market wizard data built to be commited to wizard fresh runtime"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_SNIPPET_CLIENT_APP(sdk2.Resource):
    """Market snippet-client application"""

    releasable = True
    releasers = ["MARKET-MBI"] + marketsre + market_teamcity + robot_market_infra


class MARKET_SNIPPET_TMS_APP(sdk2.Resource):
    """Market snippet-tms application"""

    releasable = True
    releasers = ["MARKET-MBI"] + marketsre + market_teamcity + robot_market_infra


class MARKET_ANALYTICS_PLATFORM_APP(sdk2.Resource):
    """Market analytics-platform application"""

    releasable = True
    releasers = ["MARKET"] + marketsre + market_teamcity + robot_market_infra


class MARKET_ANALYTICS_TMS_APP(sdk2.Resource):
    """Market analytics-tms application"""

    releasable = True
    releasers = ["MARKET"] + marketsre + market_teamcity + robot_market_infra


class MARKET_NOTIFIER_APP(sdk2.Resource):
    """Market notifier application"""

    releasable = True
    releasers = ["MARKET"] + marketsre + market_teamcity + robot_market_infra


class MARKET_NOTIFIER_CONFIG(sdk2.Resource):
    """Market Notifier configuration"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_DATA_NOTIFIER(MARKET_DATA_OTHER):
    """
        Ресурс data-getter для market-notifier
    """


class MARKET_JAVA_SEC_MIGRATOR_APP(sdk2.Resource):
    """Market java-sec-migrator application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_JAVA_SEC_HTTP_PROXY_APP(sdk2.Resource):
    """Market java-sec-http-proxy application"""

    releasable = True
    releasers = ["MARKET-MBI"] + marketsre + market_teamcity + robot_market_infra


class MARKET_MBI_DATA_ARCHIVER_APP(sdk2.Resource):
    """Market mbi-data-archiver application"""

    releasable = True
    releasers = market_mbi_group + market_sre_group + market_teamcity + robot_market_infra


class MARKET_MBI_DATA_ARCHIVER_CONFIG(sdk2.Resource):
    """Market mbi-data-archiver config"""

    releasable = True
    releasers = market_mbi_group + market_sre_group + market_teamcity + robot_market_infra


class MARKET_MBO_OFFERS_API(sdk2.Resource):
    """Market MBO OFFERS API application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBO_HTTP_EXPORTER(sdk2.Resource):
    """Market MBO HTTP EXPORTER application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_CHECKOUTER_DB_APP(sdk2.Resource):
    """Market Checkout checkouter-db application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBO_FLUME_NG(sdk2.Resource):
    """Market MBO FLUME NG application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBO_CARD_API_APP(sdk2.Resource):
    """Market MBO CARD API application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBO_CARD_API_FLUME_NG_AUTOGENERATION_CONFIG(sdk2.Resource):
    """Market flume autogeneration config for MBO CARD API"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBO_TMS_FLUME_NG_CLUSTERIZER_CONFIG(sdk2.Resource):
    """Market flume clusterizer config for MBO CARD API"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_JAVA_ASYNC_PROFILER(sdk2.Resource):
    """async-profiler for java (manual releases), check https://wiki.yandex-team.ru/market/mbo/howto/async-profiler/"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_CONFIG_PRIMER(sdk2.Resource):
    """config-primer application"""

    releasable = True
    releasers = marketsre + market_teamcity + robot_market_infra


class MARKET_MBO_REACT_UI(sdk2.Resource):
    """Market MBO REACT UI application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBO_AUDIT_APP(sdk2.Resource):
    """Market MBO AUDIT application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBO_CARD_API_FLUME_NG_CLUSTERIZER_CONFIG(sdk2.Resource):
    """Market flume clusterizer config for MBO CARD API"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_HROOM_APP(sdk2.Resource):
    """MARKETINDEXER-26079
    """

    releasable = True
    releasers = market_idx_group + market_sre_group + robot_market_infra


class MARKET_WRATH(sdk2.Resource):
    """MARKETFRONTECH-1627
    """

    releasable = True
    releasers = market_idx_group + market_sre_group + robot_market_infra


class MARKET_DELIVERY_AFTER_SHIP_INTEGRATION_APP(sdk2.Resource):
    """DELIVERY-9118
    """

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBO_FLUME_NG_CLUSTERIZER_CONFIG(sdk2.Resource):
    """Market flume clusterizer config"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBO_FLUME_NG_AUTOGENERATION_CONFIG(sdk2.Resource):
    """Market flume autogeneration config"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBO_FLUME_NG_MBO_UI_CONFIG(sdk2.Resource):
    """Market flume mbo ui config"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBO_FLUME_NG_MBO_SOLR_CONFIG(sdk2.Resource):
    """Market flume mbo solr config"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_DELIVERY_RUSSIAN_POST_INTEGRATION_APP(sdk2.Resource):
    """DELIVERY-9209
    """

    releasable = True
    releasers = ["MARKET"]


class MARKET_DELIVERY_BUS_APP(sdk2.Resource):
    """MARKETINFRA-4470
    """

    releasable = True
    releasers = ["MARKET"]


class MARKET_DATA_DELIVERY_BUS(MARKET_DATA_OTHER):
    """
        data-getter for market-delivery-bus
    """


class MARKET_DELIVERY_BUS_CONFIG(sdk2.Resource):
    """Market Delivery Bus config"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_DATA_DELIVERY_INTEGRATION_RUSSIANPOST(MARKET_DATA_OTHER):
    """
        data-getter for yandex-delivery-russianpost-integration-app
    """


class MARKET_MBO_LITE_APP(sdk2.Resource):
    """Market MBO LITE application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MARKUP_WORKER_APP(sdk2.Resource):
    """Market Markup worker application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MARKUP_WORKER_APP_ARC(sdk2.Resource):
    """Market Markup worker application (arc)"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_DATA_MARKUP_WORKER(MARKET_DATA_OTHER):
    """Data-getter for Market Markup worker"""


class MARKET_CS_BILLING_API_APP(sdk2.Resource):
    """Market cs-billing-api application"""

    releasable = True
    releasers = marketsre + market_teamcity + robot_market_infra


class MARKET_FORECASTER_CATBOOST_MODELS_PACKAGE(sdk2.Resource):
    """ CatBoost models package to be used by Forecaster service
    """
    releasable = True
    releasers = ["MARKETMONEY", "MARKETSRE"] + robot_market_infra


class MARKET_CLASSIFIER_CATBOOST_BINARY(sdk2.Resource):
    """ CatBoost binary for classifier-trainer and clustreizer-trainer
    """
    releasable = True
    releasers = ["MARKET"]


class MARKET_CS_BILLING_TMS_APP(sdk2.Resource):
    """Market cs-billing-tms application"""

    releasable = True
    releasers = marketsre + market_teamcity + robot_market_infra


class MARKET_CLASSIFIER_TRAINER_APP(sdk2.Resource):
    """Market classifier trainer application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBO_CLASSIFIER_APP(sdk2.Resource):
    """Market mbo-classifier application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_BARCODES_CLUSTERIZER_APP(sdk2.Resource):
    """Market barcodes clusterizer application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_CS_PLACEMENT_TMS_APP(sdk2.Resource):
    """Market cs-placement-tms application"""

    releasable = True
    releasers = marketsre + market_teamcity + robot_market_infra


class MARKET_DATA_CS_PLACEMENT_TMS(MARKET_DATA_OTHER):
    """
        Ресурс data-getter для cs-placement-tms
    """


class MARKET_SOLOMON_AGENT_BINARY(sdk2.Resource):
    """Market Solomon agent"""

    releasable = True
    releasers = ["MARKET"]
    auto_backup = True


class MARKET_SOLOMON_AGENT_COMMON_BINARY(sdk2.Resource):
    """Market common Solomon agent"""

    releasable = True
    releasers = ["MARKET"]
    auto_backup = True


class MARKET_MBO_GWT_APP(sdk2.Resource):
    """Market mbo-gwt application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_GUMOFUL_BINARY(sdk2.Resource):
    """Market gumoful package (Gumoful Renderers) """

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBO_TMS_APP(sdk2.Resource):
    """Market mbo-tms application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBO_MODEL_REINDEX_APP(sdk2.Resource):
    """Market MBO MODEL REINDEX APP application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_ADFOX_BANNERS_APP(sdk2.Resource):
    """Application to collect banners' statistic from AdFox"""
    releasable = True
    releasers = ["MARKETMONEY", "MARKETSRE"] + robot_market_infra


class MARKET_PSKU_POST_PROCESSOR_APP(sdk2.Resource):
    """Market PSKU_POST_PROCESSOR application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBO_ROBOT_UI_APP(sdk2.Resource):
    """Market mbo-robot-ui application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_SUPER_CONTROLLER_APP(sdk2.Resource):
    """Market IR super-controller application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_SUPER_CONTROLLER_DATA(MARKET_DATA_OTHER):
    """Data-getter resource for super_controller"""


class MARKET_LOGISTICS_TARIFFICATOR_DATA(MARKET_DATA_OTHER):
    """Data-getter resource for logistics_tarifficator"""


class MARKET_DELIVERY_WKHTMLTOPDF_BINARY(sdk2.Resource):
    """Market DELIVERY WKHTMLTOPDF application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_LOGISTICS_LOGISTICS_LOM_CONFIG(sdk2.Resource):
    """Market Logistics Lom Config"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_LOGISTICS_LRM_CONFIG(sdk2.Resource):
    """Market Logistics Lrm Config"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBI_PARTNER_STAT_DATA(MARKET_DATA_OTHER):
    """Data-getter resource for mbi-partner-stat"""


class MARKET_LOGISTICS_NESU_DATA(MARKET_DATA_OTHER):
    """Data-getter resource for logistics_nesu"""


class MARKET_LOGISTICS_FOR_SHOPS_DATA(MARKET_DATA_OTHER):
    """Data-getter resource for logistics_4_shops"""


class MARKET_PARAMETRIZATOR_DATA(MARKET_DATA_OTHER):
    """Data-getter resource for parametrizator"""


class MARKET_KGB_COMMON_CONFIGS(sdk2.Resource):
    """Market KGB common configs"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_BUKER_APP(sdk2.Resource):
    """Market buker application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_DATA_BUKER(MARKET_DATA_OTHER):
    """
        Cataloger's data
    """


class MARKET_CATALOGER_APP(sdk2.Resource):
    """Market cataloger application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_CATALOGER_CONFIG(sdk2.Resource):
    """Market cataloger config"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_DATA_CATALOGER(MARKET_DATA_OTHER):
    """
        Cataloger's data
    """


class MARKET_MBO_IR_TMS_APP(sdk2.Resource):
    """Market mbo-ir-tms application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBO_LOGS_APP(sdk2.Resource):
    """Market mbo-logs application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBO_TOOL_APP(sdk2.Resource):
    """Market mbo-tool application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBO_JEMALLOC_LIB(sdk2.Resource):
    """jemalloc lib"""

    releasable = False


class MARKET_MBO_SOLOMON_AGENT_BINARY(sdk2.Resource):
    """Market Solomon agent with configs for MBO"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_IR_SOLOMON_AGENT_BINARY(sdk2.Resource):
    """Market Solomon agent with configs for IR"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_ORACLE_INSTANT_CLIENT(sdk2.Resource):
    """Market oracle instant client"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_COST_FORECASTER_APP(sdk2.Resource):
    """Бинарь и данные для запуска в sandbox.
    """

    releasable = True
    releasers = ['manushkin', 'k-mikhaylov', 'fedorovarthur']


class MARKET_LOGSHATTER_APP(sdk2.Resource):
    """Market Logshatter application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_LOGSHATTER_CONFIG(sdk2.Resource):
    """Market Logshatter configs"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_LOGSHATTER_STRESS_APP(sdk2.Resource):
    """Market Logshatter stress application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_LOGSHATTER_STRESS_CONFIG(sdk2.Resource):
    """Market Logshatter stress configs"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_HEALTH_STRESS_CONFIG(sdk2.Resource):
    """Market Health stress configs"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_HEALTH_UNIFIED_AGENT_SCRIPTS(sdk2.Resource):
    """Market Health unified-agent scripts"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_HEALTH_LOGSHATTER_CONFIG(sdk2.Resource):
    """Market Logshatter configs"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_PORCHMARK_REPORT(sdk2.Resource):
    any_arch = True
    __default_attribute__ = sdk2.parameters.String


class MARKET_CLICKPHITE_APP(sdk2.Resource):
    """Market Clickphite application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_CLICKPHITE_CONFIG(sdk2.Resource):
    """Market Clickphite configs"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_CLICKPHITE_STRESS_APP(sdk2.Resource):
    """Market Clickphite stress application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_CLICKPHITE_STRESS_CONFIG(sdk2.Resource):
    """Market Clickphite stress configs"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_HEALTH_CLICKPHITE_CONFIG(sdk2.Resource):
    """Market Clickphite configs"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_PORCHMARK_WORKDIR(sdk2.Resource):
    any_arch = True
    __default_attribute__ = sdk2.parameters.String


class MARKET_OFFERS_CLUSTERIZER_APP(sdk2.Resource):
    """Market IR offers-clusterizer application"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_EXPERIMENT_ANALYZER_DATA_GRABBER_INPUT(sdk2.Resource):
    any_arch = True
    __default_attribute__ = sdk2.parameters.String


class MARKET_EXPERIMENT_ANALYZER_DATA_GRABBER_OUTPUT(sdk2.Resource):
    any_arch = True
    __default_attribute__ = sdk2.parameters.String


class MARKET_EXPERIMENT_ANALYZER_DATA_GRABBER_RESULT(sdk2.Resource):
    any_arch = True
    __default_attribute__ = sdk2.parameters.String


class MARKET_DELIVERY_TARIFF_TO_YT(sdk2.Resource):
    """st/MARKETOUT-30643
    """
    releasable = True
    releasers = ['MARKET', 'manushkin', 'nickderev', 'vlid']


class MARKET_SEO_EXPS_CONFIG(sdk2.Resource):
    """Market seo-exp config"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_PRICING_NAMED_EXECUTABLE(sdk2.Resource):
    """Market dynamic pricing deadstock"""

    releasable = True
    releasers = ["MARKET"]
    auto_backup = True
    env_type = sdk2.parameters.String("Environment: testing/prestable/production", required=True)
    task_type = sdk2.parameters.String("Task type", required=True)


class MARKET_PRICING_UDFS(sdk2.Resource):
    """Market dynamic pricing udfs"""

    releasable = True
    releasers = ["MARKET"]
    auto_backup = True


class MARKET_PRICING_PYTHON_UDFS(sdk2.Resource):
    """Market dynamic pricing python udfs"""
    releasable = True
    releasers = ["MARKET"]
    auto_backup = True
    env_type = sdk2.parameters.String("Environment: testing/prestable/production", required=True)


class MARKET_PRICING_DEADSTOCK_STATUS(sdk2.Resource):
    """Market dynamic pricing deadstock"""

    releasable = True
    releasers = ["MARKET"]
    auto_backup = True
    env_type = sdk2.parameters.String("Environment: testing/prestable/production", required=True)


class MARKET_PRICING_DEADSTOCK_ALMOST(sdk2.Resource):
    """Market dynamic pricing deadstock"""

    releasable = True
    releasers = ["MARKET"]
    auto_backup = True
    env_type = sdk2.parameters.String("Environment: testing/prestable/production", required=True)


class MARKET_PRICING_DEADSTOCK_SALE_STATS(sdk2.Resource):
    """Market dynamic pricing deadstock"""

    releasable = True
    releasers = ["MARKET"]
    auto_backup = True
    env_type = sdk2.parameters.String("Environment: testing/prestable/production", required=True)


class MARKET_PRICING_DEADSTOCK_RULES_UPLOADER(sdk2.Resource):
    """Market dynamic pricing deadstock"""

    releasable = True
    releasers = ["MARKET"]
    auto_backup = True
    env_type = sdk2.parameters.String("Environment: testing/prestable/production", required=True)


class MARKET_PRICING_DEADSTOCK_SALE_ASSORTMENT(sdk2.Resource):
    """Market dynamic pricing deadstock"""

    releasable = True
    releasers = ["MARKET"]
    auto_backup = True
    env_type = sdk2.parameters.String("Environment: testing/prestable/production", required=True)


class MARKET_PRICING_DEADSTOCK_SALE_PRICES(sdk2.Resource):
    """Market dynamic pricing deadstock"""

    releasable = True
    releasers = ["MARKET"]
    auto_backup = True
    env_type = sdk2.parameters.String("Environment: testing/prestable/production", required=True)


class MARKET_PRICING_GEN_KWYT_CONFIG(sdk2.Resource):
    """Market dynamic pricing kwyt config generator"""

    releasable = True
    releasers = ["MARKET"]
    auto_backup = True
    env_type = sdk2.parameters.String("Environment: development/testing/production", required=True)


class MARKET_PRICING_MAIN_APPS(sdk2.Resource):
    """Market dynamic pricing binaries for main pipeline"""

    releasable = True
    releasers = ["MARKET"]
    auto_backup = True
    env_type = sdk2.parameters.String("Environment: testing/prestable/production", required=True)


class MARKET_PRICING_DATA_PREPARATION(sdk2.Resource):
    """Market pricing data preparation (make assortments)"""

    releasable = True
    releasers = ["MARKET"]
    auto_backup = True
    env_type = sdk2.parameters.String("Environment: testing/prestable/productionn", required=True)


class MARKET_MANUAL_PRICING_APP(sdk2.Resource):
    """Manual pricing for example: fix, rrc, sales"""

    releasable = True
    releasers = ["MARKET"]
    auto_backup = True
    env_type = sdk2.parameters.String("Environment: testing/prestable/production", required=True)


class MARKET_PRICING_BUILD_WATSON_PARSERS(sdk2.Resource):
    """Market pricing build watson parsers"""

    releasable = True
    releasers = ["MARKET"]
    auto_backup = True
    env_type = sdk2.parameters.String("Environment: testing/prestable/production", required=True)


class MARKET_ZOOKEEPER_SERVER_LIBS(sdk2.Resource):
    """Resource with jars for build zookeeper deb-package in Market"""

    releasable = True
    releasers = ["MARKETSRE"]
    env_type = sdk2.parameters.String("Environment: development/testing/production", required=True)


class MARKET_CANONIC_TEST_APP(sdk2.Resource):
    """Market canonic test app"""

    releasable = True
    releasers = ["MARKET"]
    auto_backup = True
    env_type = sdk2.parameters.String("Environment: testing/prestable/production", required=True)


class MARKET_PRICING_PREPARE_DATA_FOR_AXAPTA(sdk2.Resource):
    """Market pricing prepare data for axapta"""

    releasable = True
    releasers = ["MARKET"]
    auto_backup = True
    env_type = sdk2.parameters.String("Environment: testing/prestable/production", required=True)


class MARKET_INDEXER_IAAS_TASKS(sdk2.Resource):
    """Market Indexer IAAS binary tasks"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_PRICING_CHECKS(sdk2.Resource):
    """Market pricing checks before axapta"""

    releasable = True
    releasers = ["MARKET"]
    auto_backup = True
    env_type = sdk2.parameters.String("Environment: testing/prestable/production", required=True)


class MARKET_COMMON_PROXY_MONITOR_BINARY(sdk2.Resource):
    """Market common proxy monitor binary"""

    executable = True
    releasable = True
    releasers = marketsre + ["vtrouble", "robot-market-infra"]


class MARKET_ACCESS_AGENT(sdk2.Resource):
    releasable = True
    releasers = ["MARKET"]


class MARKET_ACCESS_AGENT_FOR_REPORT(sdk2.Resource):
    releasable = True
    releasers = ["MARKET"]


class PORTO_LAYER_MARKET_PRICELABS_FRONT(sdk2.Resource):
    """A market porto layer for pricelabs_front"""
    releasable = True
    releasers = ["MARKET"]
    auto_backup = True


class MARKET_PRICING_EXPIRING_GOODS(sdk2.Resource):
    """Market expiring goods binaries for main pipeline"""

    releasable = True
    releasers = ["MARKET"]
    auto_backup = True
    env_type = sdk2.parameters.String("Environment: testing/prestable/production", required=True)


class MARKET_NLTK_PUNKT(sdk2.Resource):
    """NLTK punkt package for nltk.tokenize"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBO_MDM_DQ(sdk2.Resource):
    releasable = True
    releasers = ["MARKET"]
    auto_backup = True


class MARKET_MBO_MDM_DQ_CONFIG(sdk2.Resource):
    releasable = True
    releasers = ["MARKET"]
    auto_backup = True


class MARKET_MBO_MDM_DQ_WORKFLOW(sdk2.Resource):
    releasable = True
    releasers = ["MARKET"]
    auto_backup = True


class MARKET_MBO_MDM_DQ_SCHEDULER(sdk2.Resource):
    releasable = True
    releasers = ["MARKET"]
    auto_backup = True


class MARKET_MBO_MDM_INFRA_CONFIG(sdk2.Resource):
    releasable = True
    releasers = ["MARKET"]
    auto_backup = True


class PORTO_LAYER_MARKET_MBO_MDM_DQ_JAVA(sdk2.Resource):
    releasable = True
    releasers = ["MARKET"]
    auto_backup = True


class MARKET_MBO_MDM_DQD(sdk2.Resource):
    releasable = True
    releasers = ["MARKET"]
    auto_backup = True


class MARKET_MBO_MDM_DQD_CONFIG(sdk2.Resource):
    releasable = True
    releasers = ["MARKET"]
    auto_backup = True


class MARKET_QUOTER(sdk2.Resource):
    releasable = True
    releasers = ["MARKET"]


class MARKET_QUOTER_DEPLOY(sdk2.Resource):
    releasable = True
    releasers = ["MARKET"]


class MARKET_MBO_MDM_DQ_PLUGIN(sdk2.Resource):
    releasable = True
    releasers = ["MARKET"]
    auto_backup = True


class MARKET_PRICING_PROMO_SUBSIDIES_3P(sdk2.Resource):
    """Market pricing promo subsidies for 3p binaries for main pipeline"""

    releasable = True
    releasers = ["MARKET"]
    auto_backup = True
    env_type = sdk2.parameters.String("Environment: testing/prestable/production", required=True)


class MARKET_MBO_SAAS_PUSH_CONF_PROD(sdk2.Resource):
    """Market saas-push config for MBO (prod)"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBO_SAAS_PUSH_CONF_TESTING(sdk2.Resource):
    """Market saas-push config for MBO (testing)"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBO_CARD_RENDER_PUSH_CONF_PROD(sdk2.Resource):
    """Market saas-push config for card-render (prod)"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBO_CARD_RENDER_SAAS_PUSH_CONF_TESTING(sdk2.Resource):
    """Market saas-push config for card-render (testing)"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_MBO_CARD_RENDER_SAAS_PUSH_CONF_PROD(sdk2.Resource):
    """Market saas-push config for card-render (prod)"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_PRICING_PERSONAL_PROMO(sdk2.Resource):
    """Market pricing personal promo binaries for main pipeline"""

    releasable = True
    releasers = ["MARKET"]
    auto_backup = True
    env_type = sdk2.parameters.String("Environment: testing/prestable/production", required=True)


class MARKET_FRONT_NODEJS_TEMPLATE_CONFIG(MarketFrontCommonResource):
    """Market Frontend NodeJS Template config"""


class MARKET_FRONT_EMPTY_TEMPLATE_CONFIG(MarketFrontCommonResource):
    """Market Frontend NodeJS Template config"""


class MARKET_PRICING_PROMO_YANDEX_PLUS_PRICE(sdk2.Resource):
    """Market pricing for yandex plus users binaries for main pipeline"""

    releasable = True
    releasers = ["MARKET"]
    auto_backup = True
    env_type = sdk2.parameters.String("Environment: testing/prestable/production", required=True)


class MARKET_FRONT_AUTOTEST_COMPARATOR_RESULT(sdk2.Resource):
    """Результат сравнения между собой двух отчётов автотестов фронтенда"""
    releasable = False


class MARKET_FRONT_AUTOTEST_REPORT_COMPARATOR_RESULT(sdk2.Resource):
    """Результат сравнения между собой двух отчётов автотестов фронтенда (по двум ресурсам с репортами)"""
    releasable = False


class MARKET_FRONT_APP_BUNDLE_STATS(sdk2.Resource):
    """Статистика бандла от webpack"""
    ttl = 14
    pack_tar = 2
    app_id = sdk2.Attributes.String("App ID", required=False)


class MARKET_FRONT_STATOSCOPE_REPORT(sdk2.Resource):
    """Statoscope отчет"""
    ttl = 14


class MARKET_MBI_ORDER_SERVICE_YT_MIGRATOR_APP(sdk2.Resource):
    """MBI YT migrations for order-service"""

    releasable = True
    releasers = ["MARKET"] + robot_market_infra


class MARKET_IDX_UNIVERSAL_BUNDLE(sdk2.Resource):
    ttl = 30
    releasers = marketsre + robot_market_infra + market_idx_group
    releasable = True


class MARKET_LOAD_PROD_PANDORA(sdk2.Resource):
    releasable = False


class MARKET_FRONT_TICOUNT_REPORT(sdk2.Resource):
    """Ticount отчет"""
    ttl = 14


class MARKET_IR_TRAINED_ML_MODEL(sdk2.Resource):
    """Обученная модель машинного обучения"""


class MARKET_FULFILLMENT_WMS(sdk2.Resource):
    """Market WMS application"""

    releasable = True
    releasers = market_wms_group


class GLOBAL_MARKET_B2B(MarketFrontCommonNodeAppResource):
    """Market B2B App"""


class GLOBAL_MARKET_B2B_CONFIG(MarketFrontCommonResource):
    """Market B2B App config"""


class GLOBAL_MARKET_B2B_API(MarketFrontCommonNodeAppResource):
    """Market B2B FAPI NodeJS"""


class GLOBAL_MARKET_B2B_API_CONFIG(MarketFrontCommonResource):
    """Market B2B FAPI NodeJS config"""


class GLOBAL_MARKET_B2C(MarketFrontCommonNodeAppResource):
    """Market B2C App"""


class GLOBAL_MARKET_B2C_CONFIG(MarketFrontCommonResource):
    """Market B2C App config"""


class GLOBAL_MARKET_B2C_API(MarketFrontCommonNodeAppResource):
    """Market B2C FAPI NodeJS"""


class GLOBAL_MARKET_B2C_API_CONFIG(MarketFrontCommonResource):
    """Market B2C FAPI NodeJS config"""


class MARKET_FRONT_CMS_SCREENSHOTS(sdk2.Resource):
    releasable = False
    ttl = 7


class MARKET_MBO_DB_JAR(sdk2.Resource):
    """Market mbo-db jar to apply migrations"""
    releasable = True
    releasers = ["MARKET"]
    auto_backup = True


class MARKET_FRONT_BUNDLE_STATS(sdk2.Resource):
    """Market Front bundle stats"""
    ttl = 14
    pack_tar = 2
    app_ref = sdk2.Attributes.String("App Ref", required=True)
    bundle_ref = sdk2.Attributes.String("Branch Ref", required=True)


class MARKET_FRONT_BUNDLE_COMPARISON_REPORT(sdk2.Resource):
    """Market Front bundle comparison reports"""
    ttl = 14


class MARKET_ADV_PROMO_CONFIG(sdk2.Resource):
    """Market Adv_Promo application configuration"""
    releasable = True
    releasers = ["MARKET"]


class MARKET_IR_UNISTAT_NGINX_CONF(sdk2.Resource):
    """
        Ресурс с конфигурацией unistat для IR
    """

    releasable = True
    releasers = ["MARKET"]


class MARKET_HEALZ_SOLOMON_CONF(sdk2.Resource):
    """
        Ресурс с конфигурацией solomon для healz метрик для Nanny
    """

    releasable = True
    releasers = ["MARKET"]


class MARKET_DEPLOY_HEALZ_SOLOMON_CONF(sdk2.Resource):
    """
        Ресурс с конфигурацией solomon для healz метрик для Yandex.Deploy
    """

    releasable = True
    releasers = ["MARKET"]


class MARKET_PRICING_REGIONAL_CALCULATOR(sdk2.Resource):
    """Market dynamic regional prices calculation"""

    releasable = True
    releasers = ["MARKET"]
    auto_backup = True
    env_type = sdk2.parameters.String("Environment: testing/prestable/productionn", required=True)


class MARKET_CAPACITY_STORAGE_CONFIG(sdk2.Resource):
    """Market Capacity Storage Service config"""

    releaseable = True
    releasers = ["MARKET"]


class MARKET_MBI_DB_JAR(sdk2.Resource):
    """Market mbi-db jar to apply migrations"""
    releasable = True
    releasers = ["MARKET"]


class MARKET_MBI_DWH_YT_MIGRATIONS_APP(sdk2.Resource):
    """MBI YT migrations for mbi-dwh"""

    releasable = True
    releasers = ["MARKET"] + robot_market_infra


class MARKET_LMS_DATA_PROCESSING_CONFIG(sdk2.Resource):
    """Market LMS Data Processing config"""

    releaseable = True
    releasers = ["MARKET"]


class MARKET_FRONT_MDM_CONF(sdk2.Resource):
    """Market front mdm configs"""

    releasable = True
    releasers = ["MARKET"]


class MARKET_SOFFERS_UDF(sdk2.Resource):
    """Market backbone offers store state UDF"""

    releasable = True


class MARKET_PROMO_PUSH_CLIENT_CONFIG_DEPLOY(sdk2.Resource):
    """Market platform-promo config for push client"""

    releasable = True
    releasers = market_promo_group + market_sre_group + robot_market_infra + market_teamcity


class MARKET_PRICING_MONITORING_SCRIPTS(sdk2.Resource):
    """MDP quick monitoring scripts"""

    releasable = True
    releasers = ["MARKET"]
    auto_backup = True
    env_type = sdk2.parameters.String("Environment: development/testing/production", required=True)
