# coding: utf-8
# this file cut from arcadia/sandbox/projects/market/resources/__init__.py
# for PY23 supporting

from sandbox import sdk2

# Groups
market_idx_group = ['MARKET-IDX']
market_sre_group = ['MARKETSRE']

# Robots
market_teamcity = ['teamcity']  # It's used to release tasks
robot_market_infra = ['robot-market-infra']  # It's used to release tasks


class MARKET_OFFERS_ROBOT2_APP(sdk2.Resource):
    """Market Indexer offers robot application"""

    ttl = 30
    releasable = True
    releasers = market_idx_group + market_sre_group + robot_market_infra + market_teamcity


class MARKET_REPORT_DIST(sdk2.Resource):
    """Market report dists built by indexer"""

    ttl = 7  # TODO: adjust as needed
    releasable = True
    auto_backup = True

    generation = sdk2.parameters.String("Generation of the dist, usually in 'yyyyMMdd_HHmm' format", required=True)
    dist_name = sdk2.parameters.String("Dist name, usually in 'some-thing-9' format", required=True)
    mi_type = sdk2.parameters.String("Marketindexer type (usually stored in /etc/yandex/marketindexer/type file on the indexer)", required=True)
    env_type = sdk2.parameters.String("Environment: development/testing/production", required=True)


class MARKET_REPORT_DIST_META(sdk2.Resource):
    '''Meta info for market report dists'''

    ttl = 7  # Same as MARKET_REPORT_DIST ttl
    releasable = True
    auto_backup = True

    generation = sdk2.parameters.String("Generation of the dist, usually in 'yyyyMMdd_HHmm' format", required=True)
    mi_type = sdk2.parameters.String("Marketindexer type (usually stored in /etc/yandex/marketindexer/type file on the indexer)", required=True)
    env_type = sdk2.parameters.String("Environment: development/testing/production", required=True)
    indexer_revision = sdk2.parameters.String("Indexer revision", required=True)
    indexer_version = sdk2.parameters.String("Indexer version")
    is_half = sdk2.parameters.String("Is generation build in half_mode")


class MARKET_REPORT_PUBLISHER_CONF(sdk2.Resource):
    '''Meta info for market report dists'''

    ttl = 7  # Same as MARKET_REPORT_DIST ttl
    releasable = True
    auto_backup = True

    generation = sdk2.parameters.String("Generation of the dist, usually in 'yyyyMMdd_HHmm' format", required=True)
    mi_type = sdk2.parameters.String("Marketindexer type (usually stored in /etc/yandex/marketindexer/type file on the indexer)", required=True)
    env_type = sdk2.parameters.String("Environment: development/testing/production", required=True)
    indexer_revision = sdk2.parameters.String("Indexer revision", required=True)
    indexer_version = sdk2.parameters.String("Indexer version", required=True)
