# coding: utf-8


from sandbox import sdk2
from sandbox.projects.resource_types import marketsre


class MARKET_SRE_ABSTRACT_RESOURCE(sdk2.Resource):
    releasable = True
    auto_backup = True
    releasers = marketsre


class MARKET_ALERTS_CONFIGURATOR(MARKET_SRE_ABSTRACT_RESOURCE):
    """Resource for market_alerts_configurator executable"""
    releasers = ["MARKET"]


class MARKET_DEPLOY_LOGKEEPER_BINARY(MARKET_SRE_ABSTRACT_RESOURCE):
    """Layer for Y.Deploy with logkeeper-minion"""
    releasers = ["MARKET"]


class MARKET_COMMON_DEPLOY_JUGGLER_BUNDLE(MARKET_SRE_ABSTRACT_RESOURCE):
    """Bundle with basic Deploy checks"""
    releasers = ["MARKET"]


class PORTO_LAYER_MARKET_EXPERIMENTS(MARKET_SRE_ABSTRACT_RESOURCE):
    releasers = ["MARKET"]


class MARKET_PROSTARTER(MARKET_SRE_ABSTRACT_RESOURCE):
    """Tool to run services in different clouds"""
    releasers = ["MARKET"]


class MARKET_DEPLOY_SRE_BINARIES(MARKET_SRE_ABSTRACT_RESOURCE):
    """The resource contains such binaries as prostarter and dpreparer."""
    releasers = ["MARKET"]


class MARKET_DEPLOY_SRE_CONFIGS(MARKET_SRE_ABSTRACT_RESOURCE):
    """The resource contains base configs and templates for nginx, push-client, etc..."""
    releasers = ["MARKET"]


class MARKET_DEPLOY_SRE_CONFIGS_NGINX(MARKET_SRE_ABSTRACT_RESOURCE):
    """The resource contains base configs and templates for nginx, etc..."""
    releasers = ["MARKET"]


class MARKET_DEPLOY_PUSH_CLIENT_BINARY(MARKET_SRE_ABSTRACT_RESOURCE):
    releasers = ["MARKET"]


class MARKET_DEPLOY_TVM_TOOL_BINARY(MARKET_SRE_ABSTRACT_RESOURCE):
    releasers = ["MARKET"]


class MARKET_DEPLOY_SOLOMON_AGENT_BINARY(MARKET_SRE_ABSTRACT_RESOURCE):
    releasers = ["MARKET"]


class PORTO_LAYER_MARKET_BASE_DEPLOY_TRUSTY(MARKET_SRE_ABSTRACT_RESOURCE):
    """A market base porto layer for trusty"""


class PORTO_LAYER_MARKET_INFRA_DEPLOY_TRUSTY(MARKET_SRE_ABSTRACT_RESOURCE):
    """A market infra porto layer for trusty"""


class PORTO_LAYER_MARKET_BASE_DEPLOY_XENIAL(MARKET_SRE_ABSTRACT_RESOURCE):
    """A market base porto layer for xenial"""


class PORTO_LAYER_MARKET_INFRA_DEPLOY_XENIAL(MARKET_SRE_ABSTRACT_RESOURCE):
    """A market infra porto layer for xenial"""


class MARKET_DRLOGGER_NEL_CONFIG(MARKET_SRE_ABSTRACT_RESOURCE):
    """Config for Market DRLogger NEL."""


class MARKET_DEPLOY_INFRA_JUGGLER_BUNDLE(MARKET_SRE_ABSTRACT_RESOURCE):
    """Bundle with infra_box Deploy checks"""
    releasers = ["MARKET"]


class MARKET_DEPLOY_APP_JUGGLER_BUNDLE(MARKET_SRE_ABSTRACT_RESOURCE):
    """Bundle with app box Deploy checks"""
    releasers = ["MARKET"]


class MARKET_DEPLOY_NGINX_JUGGLER_BUNDLE(MARKET_SRE_ABSTRACT_RESOURCE):
    """Bundle with nginx box Deploy checks"""
    releasers = ["MARKET"]


class MARKET_DEPLOY_INFRA_JUGGLER_CHECKS(MARKET_SRE_ABSTRACT_RESOURCE):
    """Bundle with infra_box Deploy checks to build like layer"""
    releasers = ["MARKET"]


class MARKET_DEPLOY_APP_JUGGLER_CHECKS(MARKET_SRE_ABSTRACT_RESOURCE):
    """Bundle with app box Deploy checks to build like layer"""
    releasers = ["MARKET"]


class MARKET_DEPLOY_NGINX_JUGGLER_CHECKS(MARKET_SRE_ABSTRACT_RESOURCE):
    """Bundle with nginx box Deploy checks to build like layer"""
    releasers = ["MARKET"]


class MARKET_SRE_NODEJS(MARKET_SRE_ABSTRACT_RESOURCE):
    """Market SRE nodejs binary"""
    releasers = ["MARKET"]


class MARKET_SRE_DASHBOARD_NODEMODULES(MARKET_SRE_ABSTRACT_RESOURCE):
    """Market SRE nodemodules for dashboard"""
    releasers = ["MARKET"]


class MARKET_SRE_DASHBOARD(MARKET_SRE_ABSTRACT_RESOURCE):
    """Market SRE dashboard"""
    releasers = ["MARKET"]


class MarketDeplateBinary(MARKET_SRE_ABSTRACT_RESOURCE):
    """Resource Deplate executable"""
    releasers = ["MARKET"]
    arcadia_build_path = 'market/sre/tools/deplate/cmd/deplate'


class MarketNewNannyServiceBinary(MARKET_SRE_ABSTRACT_RESOURCE):
    """Resource Deplate executable"""
    releasers = ["MARKET"]
    arcadia_build_path = 'market/sre/tools/new-nanny-service'


class MARKET_DOWNTIMER(MARKET_SRE_ABSTRACT_RESOURCE):
    """Resource for market downtimer executable"""
    releasers = ["MARKET"]
    arcadia_build_path = 'market/sre/tools/downtimer'
