# -*- coding: utf-8 -*-

"""
Holds resource types used in YMBOT -- images, packages, etc
"""

from sandbox import sdk2
from sandbox.sdk2 import resource
from sandbox.projects import resource_types

ymbot_releasers = [
    'ndolganov',
    'm-kurenkov',
    'nikita-zen',
    'robot-warerobot',
]

ymbot_ci_releasers = ymbot_releasers


class YmbotRosbag(resource.AbstractResource):
    ttl = "30"
    auto_backup = True

    tags = resource.Attributes.String("Tags", required=False)
    location = resource.Attributes.String("Location", required=False)

    __default_attribute__ = sdk2.parameters.String


class YmbotS3UploadResultList(resource.AbstractResource):
    ttl = "inf"
    auto_backup = True

    __default_attribute__ = sdk2.parameters.String


class YmbotLxcContainerBase(sdk2.service_resources.LxcContainer):
    ttl = "inf"
    auto_backup = True
    releasable = True
    releasers = ymbot_ci_releasers

    __default_attribute__ = sdk2.parameters.String


class YmbotPackageBase(resource_types.YA_PACKAGE):
    ttl = "inf"
    auto_backup = True
    releasable = True
    releasers = ymbot_ci_releasers


class YmbotLxcRos2DepsContainer(YmbotLxcContainerBase):
    """
    LXC image containing ROS2 dependencies and Docker for Market Robotics Builds and Tests. YMBOT-257
    """
    pass


class YmbotLxcRos2DepGenContainer(YmbotLxcContainerBase):
    """
    LXC image containing ROS2 dependencies generator for Market Robotics Builds and Tests. YMBOT-316
    """
    ttl = "5"


class YmbotLxcRos2SourceContainer(YmbotLxcContainerBase):
    """
    LXC image containing ROS2 dependencies and sources, Docker for Market Robotics Builds and Tests. YMBOT-298
    """
    ttl = "10"


class YmbotLxcRos2Container(YmbotLxcContainerBase):
    """
    LXC image containing built ROS2, Docker for Market Robotics Builds and Tests. YMBOT-299
    """
    ttl = "10"


class YmbotLxcNucContainer(YmbotLxcContainerBase):
    """
    LXC image of NUC - head device of YMBot. YMBOT-359
    """
    ttl = "10"


class YmbotLxcSimContainer(YmbotLxcContainerBase):
    """
    LXC image of Simulation. YMBOT-789
    """
    ttl = "10"


class YmbotNucAllDeb(YmbotPackageBase):
    """
    Deb-package containing all YMBot NUC binaries. YMBOT-359
    """
    ttl = "10"


class YmbotNucLxcStartupDeb(YmbotPackageBase):
    """
    Deb-package launching startup script in NUC. YMBOT-789
    """
    ttl = "10"


class YmbotSimLxcStartupDeb(YmbotPackageBase):
    """
    Deb-package launching startup simulation script in NUC. YMBOT-789
    """
    ttl = "10"


class YmbotNucHostBaseDeb(YmbotPackageBase):
    """
    Deb-package containing basic stuff for YMBot NUC host. YMBOT-559
    """
    ttl = "10"


class YmbotNucHostUserDeb(YmbotPackageBase):
    """
    Deb-package containing installation scripts of YMBot user for host NUC. YMBOT-840
    """
    ttl = "10"


class YmbotNucHostUpdatesdDeb(YmbotPackageBase):
    """
    Deb-package with updatesd daemon for host NUC. YMBOT-839
    """
    ttl = "10"
