import json
import logging
import requests

from sandbox import sdk2
from sandbox.common.errors import TaskFailure


def start_ferryman_process(out_table, saas_namespace, timestamp, ferryman_name, cluster=None):
    ferryman_request = {
        "Path": out_table,
        "Namespace": saas_namespace,
        "Timestamp": timestamp * 10**6,
        "Delta": False
    }
    if cluster:
        ferryman_request.update({"Cluster": cluster})

    ferryman_answer = {}

    try_count = 3
    logging.info('Trying to upload index...')
    for i in xrange(try_count):
        params = {'tables': json.dumps([ferryman_request])}
        try:
            r = requests.get('http://{ferryman_name}.ferryman.n.yandex-team.ru/add-full-tables'.format(
                ferryman_name=ferryman_name), params=params)
            r.raise_for_status()

            ferryman_answer = r.json()
            if r.status_code != 202:
                raise TaskFailure("Bad ferryman request, details: {}".format(ferryman_answer))
            break
        except:
            if i + 1 == try_count:
                raise
    ferryman_batch_id = ferryman_answer['batch']
    logging.info('Ferryman now uploading batch {}'.format(ferryman_batch_id))
    return ferryman_batch_id


def wait_ferryman(ferryman_name, ferryman_batch_id, time_to_wait=25 * 60):
    logging.info('Waiting for ferryman...')
    params = {'batch': ferryman_batch_id}
    response = {}
    try:
        r = requests.get('http://{ferryman_name}.ferryman.n.yandex-team.ru/get-batch-status'.format(
                         ferryman_name=ferryman_name), params=params)
        r.raise_for_status()
        response = r.json()
    except:
        pass
    if response.get('status') == 'error' or 'invalid_input' in response:
        raise TaskFailure("Error while ferryman request: {}".format(response))
    if response.get('status') != 'searchable':
        raise sdk2.WaitTime(time_to_wait)
