import logging

from sandbox import sdk2
from sandbox.projects.market.solomon_pusher.helpers import base_task
from sandbox.projects.market.solomon_pusher.helpers import common, sql
from sandbox.projects.market.solomon_pusher.helpers.common import PreviousRunResourceSaver
from sandbox.projects.market.solomon_pusher.helpers.database import DatabaseFetcher
from sandbox.projects.market.solomon_pusher.helpers.startrek import ST


class CreateStTicketsFromSensors(base_task.BaseTask):
    class Parameters(base_task.BaseTask.Parameters):
        alert_channel_name = sdk2.parameters.String('Alert channel name', required=True)

    log = logging.getLogger(__name__)

    def on_execute(self):
        sql_args = self.Parameters.additional_args
        use_date = self.Parameters.use_date_range
        service, filename, path_to_sql = common.get_path_names(self.Parameters.path_to_sql)
        config = common.read_config(common.get_service_config_file(service))
        channel_name = self.Parameters.alert_channel_name
        # https://yav.yandex-team.ru/secret/sec-01eyzx15szsnjm0j122nrgv9q2/explore/version/ver-01f0gc8rrdk3ncy7vn7bed2160
        token = sdk2.Vault.data('sec-01eyzx15szsnjm0j122nrgv9q2@ver-01f0gc8rrdk3ncy7vn7bed2160[startrek]')
        startrek = ST(config, token, channel_name, self.Parameters.is_testing)
        with PreviousRunResourceSaver(filename, self, use_date) as dates, DatabaseFetcher(config) as fetcher:
            prepared_sql = sql.prepare_sql(path_to_sql, dates + tuple(sql_args))
            columns, rows = fetcher.execute_sql(prepared_sql)
            if len(rows) == 0:
                return
            startrek.create_or_update_tickets_from_sql_rows(columns, rows)
