import logging

from sandbox import sdk2
from sandbox.projects.common import solomon
from sandbox.projects.market.solomon_pusher.helpers import base_task
from sandbox.projects.market.solomon_pusher.helpers import common, sql
from sandbox.projects.market.solomon_pusher.helpers.common import PreviousRunResourceSaver
from sandbox.projects.market.solomon_pusher.helpers.database import DatabaseFetcher


class PushSolomonSensors(base_task.BaseTask):
    log = logging.getLogger(__name__)

    def on_execute(self):
        sql_args = self.Parameters.additional_args
        use_date = self.Parameters.use_date_range
        service, filename, path_to_sql = common.get_path_names(self.Parameters.path_to_sql)
        config = common.read_config(common.get_service_config_file(service))
        # https://yav.yandex-team.ru/secret/sec-01eyzx15szsnjm0j122nrgv9q2/explore/version/ver-01f0gc8rrdk3ncy7vn7bed2160
        token = sdk2.Vault.data('sec-01eyzx15szsnjm0j122nrgv9q2@ver-01f0gc8rrdk3ncy7vn7bed2160[solomon]')

        with PreviousRunResourceSaver(filename, self, use_date) as dates, DatabaseFetcher(config) as fetcher:
            prepared_sql = sql.prepare_sql(path_to_sql, dates + tuple(sql_args))
            columns, rows = fetcher.execute_sql(prepared_sql)
            common_labels, sensors = self.prepare_solomon_data(config, columns, rows)
            solomon.push_to_solomon_v2(token, common_labels, sensors)

    def prepare_solomon_data(self, config, columns, rows):
        sensor_idx = common.index_of(columns, "sensor", -1)

        ts_idx = common.index_of(columns, "ts", -1)
        value_idx = common.index_of(columns, "value", -1)

        if sensor_idx < 0 or ts_idx < 0 or value_idx < 0:
            raise Exception('SQL query should contain at least columns: sensor, ts, value')

        sensors = [
            {
                "labels": {col: str(row[idx]) for idx, col in enumerate(columns)
                           if col not in ("ts", "value") and row[idx] is not None},
                "ts": row[ts_idx],
                "value": float(row[value_idx])
            } for row in rows
        ]

        common_labels = {
            "project": config.get("Solomon", "project"),
            "cluster": config.get("Solomon", "cluster"),
            "service": config.get("Solomon", "service")
        }

        self.log.info('Fetched {} rows'.format(len(rows)))

        return common_labels, sensors
